package jmind.core.jdbc;

import javax.sql.DataSource;

import org.springframework.jdbc.support.incrementer.MySQLMaxValueIncrementer;

/**
 * <bean id="idGenarater"
  class="org.springframework.jdbc.support.incrementer.MySQLMaxValueIncrementer">
        <property name="incrementerName" value="forumidtable"/>  // 自增长ID字段所在的表名 “forumidtable”
        <property name="columnName" value="sequence_id"/>         // 自增长ID字段 “sequence_id”
        <property name="cacheSize" value="10"/>                            //  一次生成ID数目，此设置中一次生成十个，以后从缓存中取，就不用每次都访问数据库了，这样能提高效率
        <property name="dataSource" ref="dataSource"/>                 // 数据源
 </bean>
 * @author wbxie
 * 2014-2-26
 * @param <E>
 */
public class Sequence {
    private final MySQLMaxValueIncrementer seq;

    public Sequence(DataSource dataSource, String incrementerName, String columnName) {
        seq = new MySQLMaxValueIncrementer(dataSource, incrementerName, columnName);
    }

    public int nextIntValue() {
        return seq.nextIntValue();
    }

    public long nextLongValue() {
        return seq.nextLongValue();
    }

    public String nextStringValue() {
        return seq.nextStringValue();
    }

}
