package jmind.core.jdbc;

import java.util.List;
import java.util.Map;

import jmind.core.manager.JdbcManager;
import jmind.base.util.GlobalConstants;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

/**
 * db 类，每一个database 继承这个类
 * @author weibo.xie
 * 2011-10-21
 */
public abstract class Database<E> extends BeanJdbc<E> {

    protected final String className;

    public Database() {
        className = this.getClass().getSimpleName();
    }

    public abstract DatabaseConfig getConfig();

    public JdbcTemplate getJdbc(int source) {
        String name = getConfig().getDatabase(source);
        return JdbcManager.getInstance().getResource(name);
    }

    /**
     * 取简单sql
     * @param key
     * @return
     */
    public String getSql(String key) {
        return getConfig().getSql(className, key);
    }

    /**
     * 取复杂sql
     * 复杂的表用此方法覆盖getSql 即可
     * s#11
     * select * from subject_%s  where id=? ;
     * @param key
     * @return
     */
    public String getComplexSql(String key) {
        String[] data = key.split(GlobalConstants.POUND_SIGN);
        String sql = getConfig().getSql(className, data[0]);
        if (data.length > 1) {
            // sql = sql.replace(GlobalConstants.DELIM, data[1]);
            //int suffix = DataUtil.toInt(data[1]) % 100;
            //sql = sql.replace(separator, String.valueOf(suffix));
            sql = String.format(sql, data[1]);

        }
        return sql;
    }

    public Number insertAndReturnKey(String key, final String keyName, final Object... args) {
        return super.insertAndReturnKey(getSql(key), keyName, args);
    }

    /**
     * 修改操作
     * @param sql
     * @param args
     * @return
     */
    @Override
    public int update(String key, Object... args) {
        return super.update(getSql(key), args);
    }

    @Override
    public E findOne(int source, String key, Object... args) {

        return super.findOne(source, getSql(key), args);
    }

    @Override
    public <T> T findColumValue(int source, String key, Class<T> requiredType, Object... args) {
        return super.findColumValue(source, getSql(key), requiredType, args);
    }

    @Override
    public <T> List<T> findColumValues(int source, String key, Class<T> requiredType, Object... args) {
        return super.findColumValues(source, getSql(key), requiredType, args);
    }

    @Override
    public List<E> find(int source, String sql, Object... args) {

        return super.find(source, getSql(sql), args);
    }

    @Override
    public int findForInt(int source, String key, Object... args) {
        return super.findForInt(source, getSql(key), args);
    }

    /**
     * 查找一条记录
     * @param sql
     * @param args
     * @return
     */
    @Override
    public Map<String, Object> findForMap(int source, String key, Object... args) {
        return super.findForMap(source, getSql(key), args);

    }

    /**
     * 查找多条记录
     * @param sql
     * @param args
     * @return
     */
    @Override
    public List<Map<String, Object>> findForList(int source, String key, Object... args) {
        return super.findForList(source, getSql(key), args);
    }

    @Override
    public List<E> sFind(int source, String key, SqlParameterSource args) {
        return super.sFind(source, getSql(key), args);
    }

}
