package jmind.core.jdbc;

import javax.sql.DataSource;

import jmind.base.lang.IProperties;

public abstract class DataSourceUtil {

    public static DataSource createSource(String name, IProperties p) {
        if ("hikari".equals(p.getProperty("jdbc." + name + ".datasource"))) {
            return new HikariDataSource().getSource(name, p);
        } else {
            return new DbcpBasicDataSource().getSource(name, p);
        }

    }

}
