package jmind.core.ip;

import java.io.Serializable;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import jmind.base.util.DataUtil;

public class Location implements Serializable {
    private String province;
    private String city;
    private String district;
    private String address;
    private int a ;
    private Date b;

    private static Pattern k = Pattern.compile("^中?国?([^省]{2,3})省([^市]{2,4})市(.*)$");
    //private static Pattern k = Pattern.compile("^中?国?([^省]{2,3})省([^市]{2,4})市([^市县区]{2,4}[市县区])(.*)$");
    private static Pattern z = Pattern.compile("^中?国?([^自]{2,5})自治区([^市]{2,4})市(.*)$");
    private static Pattern p = Pattern.compile("^中?国?(北京|上海|天津|重庆)市?([^区县]{2,3}[区县])(.*)$");
    private static Pattern p0 = Pattern.compile("^(北京)市市辖区([^区]{2,3}区)(.*)$");
    private static Pattern p1 = Pattern.compile("^(北京)市县([^县]{2,3}县)(.*)$");
    //private static Pattern bj = Pattern.compile("^中?国?([^区]{2,3}区)(.*)$");
    private static Pattern q = Pattern.compile("^([^市县区]{2,4}[市县区])(.*)$");

    public Location() {

    }

    private static Pattern Municipalities = Pattern.compile(".*(香港|澳门|北京|上海|天津|重庆|内蒙古|广西|新疆|宁夏|西藏).*");

    public static Location parseProvice(String location) {
        Location l = new Location();
        l.address = location;
        int end = location.indexOf("省");
        if (end > 0) {
            l.province = location.substring(0, end).trim();
        } else {
            Matcher matcher = Municipalities.matcher(location);
            if (matcher.matches()) {
                l.province = matcher.group(1);
            }
        }
        return l;
    }

    public Location(String address) {
        this.address = address;
        //first match 市辖区
        Matcher m = p0.matcher(address);
        boolean matched = m.matches();
        if (!matched) { // then match 北京县
            m = p1.matcher(address);
            matched = m.matches();
        }
        if (!matched) { //match 直辖市
            m = p.matcher(address);
            matched = m.matches();
        }
        //System.out.println(address+" matches 直辖市:"+matched);
        if (matched) {
            city = m.group(1);
            district = m.group(2);
            province = city;
        } else {
            if (address.indexOf("自治区") > 0) {
                m = z.matcher(address);
            } else {
                m = k.matcher(address);
            }
            matched = m.matches();
            //	System.out.println(address+" matches 省:"+matched);
            if (matched) {
                city = m.group(2);
                province = m.group(1);
                m = q.matcher(this.address);
                if (m.matches()) {
                    district = m.group(1);
                }
            }
        }

        if (DataUtil.isEmpty(city)) {
            Matcher matcher = Municipalities.matcher(address);
            if (matcher.matches()) {
                province = matcher.group(1);
                city = province;
            }
        }
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String provience) {
        this.province = provience;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getDistrict() {
        return district;
    }

    public void setDistrict(String district) {
        this.district = district;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String toString() {

        return address;
    }


    public int getA() {
        return a;
    }

    public void setA(int a) {
        this.a = a;
    }

    public Date getB() {
        return b;
    }

    public void setB(Date b) {
        this.b = b;
    }

    public static void main(String[] args) {
        Location l = new Location("广东省深圳市");
        System.out.println(l.getAddress());
        System.out.println(l.getProvince());
        System.out.println(l.getCity());
    }
}
