package jmind.core.ip;

import java.io.IOException;

import jmind.core.log.LogUtil;
import jmind.base.util.DataUtil;

import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

/**
 *  通过网站接口 查询ip 
 * @author weibo-xie
 * 2012-2-8
 */
public class IPApi {

    public static Location getLocation(String ip, IPSeeker p) {
        String pro = p.getCountry(ip);
        Location location = null;
        if (!DataUtil.isEmpty(pro)) {
            location = new Location(pro);
        }
        if (location == null || DataUtil.isEmpty(location.getProvince())) {
            pro = getByApi(ip);
            if (!DataUtil.isEmpty(pro))
                location = new Location(pro);
        }

        return location;
    }

    public static String getByApi(String ip) {
        String address = ip138(ip);
        if (address == null) {
            address = pconline(ip);
            if (address == null) {
                address = youdao(ip);
            }
        }
        return address;
    }

    public static String ip138(String ip) {
        String api = "http://ip138.com/ips138.asp?action=2&ip=" + ip;
        try {
            Thread.sleep(2000);
            Document doc = Jsoup.connect(api).get();
            String data = doc.select("ul.ul1 >li").first().text();
            if (!DataUtil.isEmpty(data)) {
                int index = data.indexOf("：");
                if (index > 0)
                    data = data.substring(index + 1);
            }
            return data;
        } catch (Exception e) {
            LogUtil.error(e);

        }
        return null;
    }

    /**
     * http://blog.sina.com.cn/s/blog_75699b620100x0qz.html
     * @param ip
     * @return
     */
    public static String liqwei(String ip) {
        String api = "http://api.liqwei.com/location/?ip=" + ip;
        try {
            Document doc = Jsoup.connect(api).get();
            String body = doc.text();
            body = body.substring(body.indexOf(",") + 1);
            LogUtil.debug("liqwei,ip=" + ip + body);
            return body;
        } catch (IOException e) {
            LogUtil.error(e);
            return null;
        }
    }

    /**
     * http://whois.pconline.com.cn/?ip=222.247.167.14
     */
    public static String pconline(String ip) {
        // String api="http://whois.pconline.com.cn/ipJson.jsp?ip="+ip ;
        String api = "http://whois.pconline.com.cn/ip.jsp?ip=" + ip;
        try {
            Document doc = Jsoup.connect(api).get();
            String body = doc.text();
            LogUtil.debug("pconline,ip=" + ip + body);
            return body;
        } catch (IOException e) {
            LogUtil.error(e);
            return null;
        }

    }

    /**
     * type ip  mobile id(省份证）
     * @param ip
     * @return
     */
    public static String youdao(String ip) {
        String api = "http://www.youdao.com/smartresult-xml/search.s?type=ip&q=" + ip;
        try {
            Document doc = Jsoup.connect(api).get();
            String body = doc.select("location").text();
            LogUtil.debug("youdao,ip=" + ip + body);
            return body;
        } catch (IOException e) {
            LogUtil.error(e);
            return null;
        }
    }

    public static void main(String arg[]) {
        //  110.174.228.88  71.132.142.234 
        String ip = "114.239.40.159";
        System.out.println(ip138(ip));
        //  System.out.println(		liqwei(ip));
        //    System.out.println(		pconline(ip));
        //    System.out.println(		youdao(ip));
        //   System.out.println(getLocation(ip));
    }

}
