package jmind.core.image.ocr;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;

import javax.imageio.ImageIO;

import jmind.base.util.DataUtil;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.QRCodeReader;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;

/**
 * Zxing qrcode 二维码的使用（生成和解析）
 * http://zjnbshifox.iteye.com/blog/1461464
 * http://wanghlwin.iteye.com/blog/1460463
 * @author weibo-xie
 * 2012-8-8
 */
public class ZxingQrCode {
    /**
     * 生成二维码
     * @param filePath 文件路径
     * @param content  二维码内容
     * @param qrCodeSize  图片高宽 ，这里是正方形
     * @param imageFormat 图片类型 ，JPEG，png
     */
    public static void createQrCode(String filePath, String content, int qrCodeSize, String imageFormat) {
        try {
            // Create the ByteMatrix for the QR-Code that encodes the given String.
            Hashtable<EncodeHintType, ErrorCorrectionLevel> hintMap = new Hashtable<EncodeHintType, ErrorCorrectionLevel>();
            hintMap.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.L);
            QRCodeWriter qrCodeWriter = new QRCodeWriter();
            BitMatrix byteMatrix = qrCodeWriter.encode(content, BarcodeFormat.QR_CODE, qrCodeSize, qrCodeSize, hintMap);

            // Make the BufferedImage that are to hold the QRCode
            int matrixWidth = byteMatrix.getWidth();
            BufferedImage image = new BufferedImage(matrixWidth, matrixWidth, BufferedImage.TYPE_INT_RGB);
            image.createGraphics();
            Graphics2D graphics = (Graphics2D) image.getGraphics();
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 0, matrixWidth, matrixWidth);

            // Paint and save the image using the ByteMatrix
            graphics.setColor(Color.BLACK);
            for (int i = 0; i < matrixWidth; i++) {
                for (int j = 0; j < matrixWidth; j++) {
                    if (byteMatrix.get(i, j)) {
                        graphics.fillRect(i, j, 1, 1);
                    }
                }
            }

            ImageIO.write(image, imageFormat, new File(filePath));
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /**
     * 解析二维码内容
     * @param filePath  图片路径
     * @return  图片内容
     * @throws IOException
     */
    public static String readQrCode(String filePath) throws IOException {

        //get the data from the input stream
        BufferedImage image = ImageIO.read(new File(filePath));

        //convert the image to a binary bitmap source
        LuminanceSource source = new BufferedImageLuminanceSource(image);
        BinaryBitmap bitmap = new BinaryBitmap(new HybridBinarizer(source));

        //decode the barcode
        QRCodeReader reader = new QRCodeReader();

        Result result = null;
        try {
            result = reader.decode(bitmap);
            return result.getText();
        } catch (ReaderException e) {
            e.printStackTrace();
            return DataUtil.EMPTY;
        }

    }

    public static void main(String[] args) throws IOException {
        String path = "d:/data/2901.jpg";
        //  createQrCode(path, "name:whl", 300, "JPEG");

        String code = readQrCode(path);
        System.out.println(code);
    }

}
