package jmind.core.image;

import java.awt.Image;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

import javax.activation.URLDataSource;
import javax.imageio.ImageIO;
import javax.imageio.stream.FileImageInputStream;

import org.jsoup.Jsoup;
import org.jsoup.Connection.Response;

public class IsImage {

	public static void main(String[] args) {
		//		for (int i = 1; i < 12; i++) {
		//			System.out.println(i + "=" + isImageF("d:/data/aa/" + i + ".jpg"));
		//
		//		}
		System.out.println(isImageF("d:/data/aa/a.jpg"));

	}

	/**
	 *  
	 * @param imageContent 文件地址，或者 url
	 * @return
	 */
	public static boolean isImage(String imageContent) {
		if (imageContent == null || imageContent.length() == 0) {
			return false;
		}
		Image img = null;
		InputStream is = null;

		try {
			//is = new ByteArrayInputStream(imageContent);
			if (imageContent.startsWith("http://")) {
				URL url = new URL(imageContent);
				URLDataSource uds = new URLDataSource(url);
				is = uds.getInputStream();
			} else {
				is = new FileInputStream(imageContent);
			}
			img = ImageIO.read(is);

			//	System.out.println(img.getClass());
			if (img == null || img.getWidth(null) <= 0 || img.getHeight(null) <= 0) {
				return false;
			}
			return true;
		} catch (Exception e) {
			e.printStackTrace();
			return false;
		} finally {
			if (is != null) {
				try {
					is.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
	}

	/**
	 * 
	 * @param url
	 * @return
	 */
	public static boolean isImg(String url) {
		try {
			Response response = Jsoup.connect(url).execute();
			String type = response.contentType();

			if (type != null && type.contains("image"))
				return true;
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return false;
	}

	/**
	* 判断文件是否为图片文件(GIF,PNG,JPG,BMP)
	* @param srcFileName 文件地址
	* @return
	*/
	public static boolean isImageF(String srcFileName) {
		FileInputStream imgFile = null;
		byte[] b = new byte[10];
		int l = -1;
		try {
			imgFile = new FileInputStream(srcFileName);

			l = imgFile.read(b);

			imgFile.close();
		} catch (Exception e) {
			e.printStackTrace();
			System.out.println("read err");
			return false;
		}
		int i = 0;
		for (byte s : b) {
			System.out.println(i + " :" + (char) s);
			i++;
		}
		if (l == 10) {
			byte b0 = b[0];
			byte b1 = b[1];
			byte b2 = b[2];
			byte b3 = b[3];
			byte b6 = b[6];
			byte b7 = b[7];
			byte b8 = b[8];
			byte b9 = b[9];
			if (b0 == (byte) 'G' && b1 == (byte) 'I' && b2 == (byte) 'F') {
				System.out.println("gif");
				return true;
			} else if (b0 == (byte) 'B' && b1 == (byte) 'M') {
				System.out.println("bmp");
				return true;
			} else if (b1 == (byte) 'P' && b2 == (byte) 'N' && b3 == (byte) 'G') {

				System.out.println("png");
				return true;
			} else if (b6 == (byte) 'J' && b7 == (byte) 'F' && b8 == (byte) 'I' && b9 == (byte) 'F') {
				System.out.println("jpg");
				return true;
			} else if (b6 == (byte) 'E' && b7 == (byte) 'x' && b8 == (byte) 'i' && b9 == (byte) 'f') {
				System.out.println("jpg");
				return true;
			} else {
				return false;
			}
		} else {
			return false;
		}
	}

	// 判断Image大小
	public float getSize(String img) {
		FileImageInputStream fiis = null;
		try {
			fiis = new FileImageInputStream(new File(img));
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		// KB
		return (float) fiis.length() / 1000;
	}
	/**
	3,判断Image宽度和高度
	ImageIcon ii = new ImageIcon(image.getPath());
	image.setHeight(String.valueOf(ii.getIconHeight()));
	image.setWidth(String.valueOf(ii.getIconWidth()));
	**/
}
