package jmind.core.image;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Transparency;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;

import javax.imageio.ImageIO;

/**
 * 图片旋转
 * @author weibo-xie
 * 2012-8-14
 */
public class ImageRotate {

    public static void main(String[] args) {
        String src = "d:/data/2901.jpg";
        try {
            rotate(src, "d:/data/1.jpg", 90, Color.BLACK);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    /**
     * 旋转图片
     * @param src 原图
     * @param target  新图
     * @param angle 角度
    http://cping1982.blog.51cto.com/601635/130066
     * @throws Exception
     */
    public static boolean rotate(String src, String target, int angle) {
        try {
            BufferedImage bufferedimage = null;
            bufferedimage = ImageIO.read(new File(src));
            int w = bufferedimage.getWidth();
            int h = bufferedimage.getHeight();
            int type = bufferedimage.getColorModel().getTransparency();
            BufferedImage img = new BufferedImage(w, h, type);
            Graphics2D graphics2d = img.createGraphics();
            graphics2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR); // 这里使用双线性过滤插件算法
            //   graphics2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING,   RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2d.rotate(Math.toRadians(angle), w / 2, h / 2);
            graphics2d.drawImage(bufferedimage, 0, 0, null);
            graphics2d.dispose();
            File f = new File(target);
            File parent = f.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            ImageIO.write(img, "png", f);
            img.flush();
            return true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean rotate(String src, String target, int angle, Color bgcolor) {
        try {
            BufferedImage image = ImageIO.read(new File(src));
            int iw = image.getWidth();//原始图象的宽度   
            int ih = image.getHeight();//原始图象的高度  
            int w = 0;
            int h = 0;
            int x = 0;
            int y = 0;
            //            angle = angle % 360;
            //            if (angle < 0)
            //                angle = 360 + angle;//将角度转换到0-360度之间  

            double ang = Math.toRadians(angle);//将角度转为弧度  
            /** 
             *确定旋转后的图象的高度和宽度 
             */

            if (angle % 180 == 0) {
                w = iw;
                h = ih;
            } else if (angle % 90 == 0) {
                w = ih;
                h = iw;
            } else {
                int d = iw + ih;
                w = (int) (d * Math.abs(Math.cos(ang)));
                h = (int) (d * Math.abs(Math.sin(ang)));
            }

            x = (w / 2) - (iw / 2);//确定原点坐标  
            y = (h / 2) - (ih / 2);
            BufferedImage rotatedImage = new BufferedImage(w, h, image.getType());
            Graphics2D gs = (Graphics2D) rotatedImage.getGraphics();
            if (bgcolor == null) {
                rotatedImage = gs.getDeviceConfiguration().createCompatibleImage(w, h, Transparency.TRANSLUCENT);
            } else {
                gs.setColor(bgcolor);
                gs.fillRect(0, 0, w, h);//以给定颜色绘制旋转后图片的背景  
            }

            AffineTransform at = new AffineTransform();
            at.rotate(ang, w / 2, h / 2);//旋转图象  
            at.translate(x, y);
            AffineTransformOp op = new AffineTransformOp(at, AffineTransformOp.TYPE_BICUBIC);
            op.filter(image, rotatedImage);
            File f = new File(target);
            File parent = f.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            ImageIO.write(rotatedImage, "png", f);
            return true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return false;

    }

}
