package jmind.core.image;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;

public class CutImage {

    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int CENTER = 0;

    public static BufferedImage cutToSquare(BufferedImage image, int l, int arg) {
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        BufferedImage cut = null;
        int arg1 = (TOP + BOTTOM) & arg;
        int arg2 = ((RIGHT + LEFT) & arg);
        if (width > height) {
            switch (arg2) {
            case LEFT:
                cut = image.getSubimage(0, 0, height, height);
                break;
            case RIGHT:
                cut = image.getSubimage((width - height), 0, height, height);
                break;
            default:
                cut = image.getSubimage((width - height) / 2, 0, height, height);
                break;
            }

        } else if (height > width) {
            switch (arg1) {
            case TOP:
                cut = image.getSubimage(0, 0, width, width);
                break;
            case BOTTOM:
                cut = image.getSubimage(0, (height - width), width, width);
                break;
            default:
                cut = image.getSubimage(0, (height - width) / 2, width, width);
                break;
            }
        } else {
            cut = image;
        }
        Image img = cut.getScaledInstance(l, l, Image.SCALE_SMOOTH);
        BufferedImage res = new BufferedImage(l, l, BufferedImage.TYPE_3BYTE_BGR);
        Graphics g = res.getGraphics();
        g.drawImage(img, 0, 0, null);
        return res;
    }

    public static void cut(File src, File des, int widht, String type, int arg) throws IOException {
        BufferedImage srcImage = ImageIO.read(src);
        BufferedImage desImage = cutToSquare(srcImage, widht, arg);
        ImageIO.write(desImage, type, des);

    }

    public static void cut(String src, String des, int width, int arg) {
        File srcF = new File(src);
        File desF = new File(des);
        String[] s = des.split("\\.");
        try {
            cut(srcF, desF, width, s[s.length - 1], arg);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        String src = "d:/data/engineering_28_1_0154d5af43783f8.jpg";
        String des1 = "d:/data/out-lt.jpg";
        String des2 = "d:/data/out-rt.jpg";
        String des3 = "d:/data/out-lb.jpg";
        String des4 = "d:/data/out=rb.jpg";
        String des5 = "d:/data/SCALE_SMOOTH.png";
        String des6 = "d:/data/out-l.jpg";
        String des7 = "d:/data/out-r.jpg";
        String des8 = "d:/data/out-t.jpg";
        String des9 = "d:/data/out-b.jpg";
        cut(src, des1, 100, LEFT + TOP);
        cut(src, des2, 100, RIGHT + TOP);
        cut(src, des3, 100, LEFT + BOTTOM);
        cut(src, des4, 100, RIGHT + BOTTOM);
        cut(src, des5, 50, CENTER);
        cut(src, des6, 100, LEFT);
        cut(src, des7, 100, RIGHT);
        cut(src, des8, 100, TOP);
        cut(src, des9, 100, BOTTOM);
    }

}
