package jmind.core.ibatis;

import java.util.List;

import org.apache.ibatis.exceptions.IbatisException;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author youfang.mu
 * @param <T>
 * @2014年4月1日 下午5:03:29
 */
public final class SqlSessionWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(SqlSessionWrapper.class);
    private SqlSessionFactoryManager sqlSessionFactory;
 
    public SqlSessionWrapper(final SqlSessionFactoryManager sqlSessionFactory) {
    	this.sqlSessionFactory = sqlSessionFactory;
    }

    public Object selectOne(String statement, Object parameter) {
        SqlSession sqlSession = null;
        try {
            sqlSession = getSqlSession();
            return sqlSession.selectOne(statement, parameter);
        } catch (Throwable t) {
            LOG.error("selectOne(" + statement + ") error:" + t.getMessage());
            throw new IbatisException("selectOne error:" + statement);
        } finally {
            if (sqlSession != null) {
                sqlSession.close();
                LOG.debug("oops, close_session_4_" + statement);
            }
        }
    }

    @SuppressWarnings("rawtypes")
	public List selectList(String statement, Object parameter, RowBounds rowBounds) {
        SqlSession sqlSession = null;
        try {
            sqlSession = getSqlSession();
            return sqlSession.selectList(statement, parameter, rowBounds);
        } catch (Throwable t) {
            LOG.error("selectList(" + statement + ") error:" + t.getMessage());
            throw new IbatisException("selectList error:" + statement);
        } finally {
            if (sqlSession != null) {
                sqlSession.close();
                LOG.debug("oops, close_session_4_" + statement);
            }
        }
    }

    public int insert(String statement, Object parameter) {
        SqlSession sqlSession = null;
        try {
            sqlSession = getSqlSession();
            return sqlSession.insert(statement, parameter);
        } catch (Throwable t) {
            LOG.error("insert(" + statement + ") error:" + t.getMessage());
            throw new IbatisException("insert error:" + statement);
        } finally {
            if (sqlSession != null) {
                sqlSession.close();
                LOG.debug("oops, close_session_4_" + statement);
            }
        }
    }

    public int update(String statement, Object parameter) {
        SqlSession sqlSession = null;
        try {
            sqlSession = getSqlSession();
            return sqlSession.update(statement, parameter);
        } catch (Throwable t) {
            LOG.error("update(" + statement + ") error:" + t.getMessage());
            throw new IbatisException("update error:" + statement);
        } finally {
            if (sqlSession != null) {
                sqlSession.close();
                LOG.debug("oops, close_session_4_" + statement);
            }
        }
    }

    public int delete(String statement, Object parameter) {
        SqlSession sqlSession = null;
        try {
            sqlSession = getSqlSession();
            return sqlSession.delete(statement, parameter);
        } catch (Throwable t) {
            LOG.error("delete(" + statement + ") error:" + t.getMessage());
            throw new IbatisException("delete error:" + statement);
        } finally {
            if (sqlSession != null) {
                sqlSession.close();
                LOG.debug("oops, close_session_4_" + statement);
            }
        }
    }

    public SqlSession getBatchSqlSession() {
        return sqlSessionFactory.getBatchSqlSession();
    }

    public SqlSession getSqlSession() {
    	return sqlSessionFactory.getSqlSession(); 
    }

    public void initResource() {
        SqlSession sqlSession = null;
        try {
            sqlSession = getSqlSession();
        } catch (Throwable t) {
        } finally {
            if (sqlSession != null) {
                sqlSession.close();
            }
        }
    }

	public SqlSessionFactoryManager getSqlSessionFactory() {
		return sqlSessionFactory;
	}
}
