package jmind.core.dubbo.pojo;

import jmind.core.json.Pojo;

import com.alibaba.dubbo.rpc.RpcContext;

public class BusEvent extends Pojo {

    private String topic;
    private String ip;
    private String val;
    // 事件产生时间
    private long time;
    //数据类型
    private Object data;

    public BusEvent(String topic) {
        this.topic = topic;
        this.ip = RpcContext.getContext().getLocalAddressString();
        this.time = System.currentTimeMillis();
    }

    public String getTopic() {
        return this.topic;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getVal() {
        return val;
    }

    public void setVal(String val) {
        this.val = val;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public Object getData() {
        return data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public long getTime() {
        return time;
    }

    public void setTime(long time) {
        this.time = time;
    }

}
