package jmind.core.dubbo.cache;

import jmind.core.cache.support.XMemCache;
import jmind.core.manager.AbstractManager;
import jmind.core.manager.XMemCacheManager;

import com.alibaba.dubbo.cache.Cache;
import com.alibaba.dubbo.cache.CacheFactory;
import com.alibaba.dubbo.common.Constants;
import com.alibaba.dubbo.common.URL;

public class XCacheFactory extends AbstractManager<Cache> implements CacheFactory {

    private final XMemCache cache = XMemCacheManager.getInstance().getResource("common");

    public Cache getCache(URL url) {
        String prefix = url.getPath() + "." + url.getParameter(Constants.METHOD_KEY);
        return getResource(prefix);
    }

    @Override
    public XCache create(String name) {
        return new XCache(name, cache);
    }

    @Override
    public void releaseResource() {

    }

}
