package jmind.core.dubbo.cache;

import jmind.core.cache.support.XMemCache;

import com.alibaba.dubbo.cache.Cache;

public class XCache implements Cache {

    private final XMemCache cache;
    private final String prefix;

    public XCache(String prefix, XMemCache cache) {
        this.prefix = prefix;
        this.cache = cache;
    }

    public void put(Object key, Object value) {
        cache.set(prefix + key, value);

    }

    public Object get(Object key) {
        return cache.get(key.toString());
    }

}
