package jmind.core.cache.support;

import jmind.base.cache.MemCache;

import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;

import java.util.concurrent.Callable;

/**
 * @author wbxie
 *         2013-12-5
 * @Cacheable(value = "andCache", key = "#userId + 'findById'")  不用设置过期时间，需要设置过期时间用 CacheMonitor
 * @see org.springframework.cache.concurrent.ConcurrentMapCache
 */
public class SpringCache implements Cache {

    private final String name;
    private final MemCache<Object, Object> cache;

    public SpringCache(String name) {
        this(name, new GuavaCache<Object, Object>());
    }

    public SpringCache(String name, MemCache<Object, Object> cache) {
        System.out.println("init SpringCache " + name);
        this.name = name;
        this.cache = cache;
    }


    @Override
    public String getName() {
        return name;
    }

    @Override
    public Object getNativeCache() {
        return cache;
    }

    @Override
    public ValueWrapper get(Object key) {
        Object value = this.cache.get(key);
        return (value != null ? new SimpleValueWrapper(value) : null);
    }

    @Override
    public void put(Object key, Object value) {
        cache.set(key, value);
    }

    @Override
    public void evict(Object key) {
        cache.delete(key);
    }

    @Override
    public void clear() {
        cache.clear();

    }

    @Override
    public <T> T get(Object o, Callable<T> callable) {
        return null;
    }

    public <T> T get(Object arg0, Class<T> arg1) {
        // TODO Auto-generated method stub
        return null;
    }

    public ValueWrapper putIfAbsent(Object arg0, Object arg1) {
        // TODO Auto-generated method stub
        return null;
    }

}
