package jmind.core.cache.support;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jmind.core.redis.Redis;
import jmind.base.util.CollectionsUtil;

/**
 * redis 缓存计数实现
 * redis 允许负数
 * @author wbxie
 * 2014-2-12
 */
public class RedisCache implements Counter<String, String> {

    private final Redis cache;

    public RedisCache(Redis redis) {
        cache = redis;
    }

    @Override
    public boolean set(String key, String value) {
        cache.set(key, value);
        return true;
    }

    @Override
    public boolean set(String key, int seconds, String value) {
        cache.set(key, value);
        cache.expire(key, seconds);
        return true;
    }

    @Override
    public boolean delete(String key) {
        cache.del(key);
        return true;
    }

    @Override
    public Map<String, String> getMulti(Collection<String> keys) {
        String[] key = CollectionsUtil.toStrArray(keys);
        List<String> mget = cache.mget(key);
        Map<String, String> values = new HashMap<String, String>();
        for (int i = 0; i < key.length; i++) {
            values.put(key[i], mget.get(i));
        }
        return values;
    }

    @Override
    public Object getCache() {
        return cache;
    }

    @Override
    public void clear() {

    }

    @Override
    public int getAndInc(String key) {
        return cache.incr(key).intValue() - 1;
    }

    @Override
    public int incAndGet(String key) {
        return cache.incr(key).intValue();
    }

    @Override
    public String get(String key) {

        return cache.get(key);
    }

    @Override
    public int inc(String key, int vaule) {
        return cache.incrBy(key, (long) vaule).intValue();
    }

    @Override
    public int decrAndGet(String key) {
        return cache.decr(key).intValue();
    }

    @Override
    public int getAndDecr(String key) {
        return decrAndGet(key) + 1;
    }

    @Override
    public int decr(String key, int value) {

        return cache.decrBy(key, (long) value).intValue();
    }

    @Override
    public boolean exists(String key) {
        return cache.exists(key);
    }

}
