package jmind.core.cache.support;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import jmind.base.cache.ConcurrentLRUCache;
import jmind.base.cache.LRUCache;
import jmind.base.cache.MemCache;

import com.google.common.collect.Maps;
import jmind.core.manager.XMemCacheManager;

public class Cache {

    private Cache() {
    }

    public static Cache getCache() {
        return Nested.instance;
    }

    static class Nested {
        private static Cache instance = new Cache();
    }

    private final MemCache<String, Object> guava = new GuavaCache<String, Object>(6000, 10, false);

    private final ConcurrentLRUCache<String, Object> PersistentCache = new ConcurrentLRUCache<String, Object>(
            new ConcurrentHashMap<String, Object>());


    public MemCache<String, Object> getCache(MemCache.Type type,String name) {
        switch (type) {
            case XMEM:
                return XMemCacheManager.getInstance().getResource(name);
            case GUAVA:
                return guava;
            case PERSISTENT:
                return PersistentCache;
            default:
                return guava;
        }
    }

    @SuppressWarnings("rawtypes")
    public Map<String, Object> stats(MemCache cache) {
        Map<String, Object> map = Maps.newHashMap();
        Object obj = cache.getCache();
        if (obj instanceof com.google.common.cache.Cache) {
            com.google.common.cache.Cache c = (com.google.common.cache.Cache) obj;
            map.put("size", c.size());
            map.put("stats", c.stats());
        } else if (obj instanceof Map) {
            Map c = (Map) obj;
            map.put("size", c.size());
        }
        return map;
    }

}
