/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.cache.support.redis;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;
import net.oschina.j2cache.ClusterPolicy;
import net.oschina.j2cache.Command;
import net.oschina.j2cache.J2CacheConfig;
import net.oschina.j2cache.cache.support.redis.ConfigureNotifyKeyspaceEventsAction;
import net.oschina.j2cache.cache.support.redis.SpringRedisActiveMessageListener;
import net.oschina.j2cache.cache.support.redis.SpringRedisMessageListener;
import net.oschina.j2cache.cache.support.util.SpringUtil;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;

public class SpringRedisPubSubPolicy
implements ClusterPolicy {
    private RedisTemplate<String, Serializable> redisTemplate;
    private net.oschina.j2cache.autoconfigure.J2CacheConfig config;
    private static boolean isActive = false;
    private String channel = "j2cache_channel";

    public void connect(Properties props) {
        String channel_name;
        J2CacheConfig j2config = SpringUtil.getBean(J2CacheConfig.class);
        this.config = SpringUtil.getBean(net.oschina.j2cache.autoconfigure.J2CacheConfig.class);
        this.redisTemplate = SpringUtil.getBean("j2CacheRedisTemplate", RedisTemplate.class);
        if ("active".equals(this.config.getCacheCleanMode())) {
            isActive = true;
        }
        if ((channel_name = j2config.getL2CacheProperties().getProperty("channel")) != null && !channel_name.isEmpty()) {
            this.channel = channel_name;
        }
        RedisMessageListenerContainer listenerContainer = SpringUtil.getBean("j2CacheRedisMessageListenerContainer", RedisMessageListenerContainer.class);
        listenerContainer.addMessageListener((MessageListener)new SpringRedisMessageListener(this, this.channel), (Topic)new PatternTopic(this.channel));
        if (isActive || "blend".equals(this.config.getCacheCleanMode())) {
            ConfigureNotifyKeyspaceEventsAction action = new ConfigureNotifyKeyspaceEventsAction();
            action.config(listenerContainer.getConnectionFactory().getConnection());
            String namespace = j2config.getL2CacheProperties().getProperty("namespace");
            String database = j2config.getL2CacheProperties().getProperty("database");
            String expired = "__keyevent@" + (database == null || "".equals(database) ? "0" : database) + "__:expired";
            String del = "__keyevent@" + (database == null || "".equals(database) ? "0" : database) + "__:del";
            ArrayList<PatternTopic> topics = new ArrayList<PatternTopic>();
            topics.add(new PatternTopic(expired));
            topics.add(new PatternTopic(del));
            listenerContainer.addMessageListener((MessageListener)new SpringRedisActiveMessageListener(this, namespace), topics);
        }
    }

    public void sendEvictCmd(String region, String ... keys) {
        if (!isActive || "blend".equals(this.config.getCacheCleanMode())) {
            String com = new Command(2, region, keys).json();
            this.redisTemplate.convertAndSend(this.channel, (Object)com);
        }
    }

    public void sendClearCmd(String region) {
        if (!isActive || "blend".equals(this.config.getCacheCleanMode())) {
            String com = new Command(3, region, new String[]{""}).json();
            this.redisTemplate.convertAndSend(this.channel, (Object)com);
        }
    }

    public void disconnect() {
        this.redisTemplate.convertAndSend(this.channel, (Object)Command.quit().json());
    }
}

