/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.cache.support;

import java.util.concurrent.Callable;
import net.oschina.j2cache.CacheChannel;
import net.oschina.j2cache.CacheObject;
import net.oschina.j2cache.NullObject;
import org.springframework.cache.Cache;
import org.springframework.cache.support.AbstractValueAdaptingCache;
import org.springframework.cache.support.NullValue;

public class J2CacheCache
extends AbstractValueAdaptingCache {
    private CacheChannel cacheChannel;
    private String j2CacheName = "j2cache";

    public J2CacheCache(String cacheName, CacheChannel cacheChannel) {
        this(cacheName, cacheChannel, true);
    }

    public J2CacheCache(String cacheName, CacheChannel cacheChannel, boolean allowNullValues) {
        super(allowNullValues);
        this.j2CacheName = cacheName;
        this.cacheChannel = cacheChannel;
    }

    public String getName() {
        return this.j2CacheName;
    }

    public void setJ2CacheNmae(String name) {
        this.j2CacheName = name;
    }

    public Object getNativeCache() {
        return this.cacheChannel;
    }

    public <T> T get(Object key, Callable<T> valueLoader) {
        T value;
        try {
            value = valueLoader.call();
        }
        catch (Exception ex) {
            throw new Cache.ValueRetrievalException(key, valueLoader, (Throwable)ex);
        }
        this.put(key, value);
        return value;
    }

    public void put(Object key, Object value) {
        this.cacheChannel.set(this.j2CacheName, String.valueOf(key), value, super.isAllowNullValues());
    }

    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        if (!this.cacheChannel.exists(this.j2CacheName, String.valueOf(key))) {
            this.cacheChannel.set(this.j2CacheName, String.valueOf(key), value);
        }
        return this.get(key);
    }

    public void evict(Object key) {
        this.cacheChannel.evict(this.j2CacheName, new String[]{String.valueOf(key)});
    }

    public void clear() {
        this.cacheChannel.clear(this.j2CacheName);
    }

    protected Object lookup(Object key) {
        CacheObject cacheObject = this.cacheChannel.get(this.j2CacheName, String.valueOf(key), new boolean[]{super.isAllowNullValues()});
        if (cacheObject.rawValue() != null && cacheObject.rawValue().getClass().equals(NullObject.class) && super.isAllowNullValues()) {
            return NullValue.INSTANCE;
        }
        return cacheObject.getValue();
    }
}

