/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.autoconfigure;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import net.oschina.j2cache.J2CacheConfig;
import net.oschina.j2cache.autoconfigure.J2CacheAutoConfiguration;
import net.oschina.j2cache.cache.support.util.J2CacheSerializer;
import net.oschina.j2cache.redis.RedisUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisClientConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.util.StringUtils;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.exceptions.JedisConnectionException;

@Configuration
@AutoConfigureAfter(value={RedisAutoConfiguration.class})
@AutoConfigureBefore(value={J2CacheAutoConfiguration.class})
public class J2CacheSpringRedisAutoConfiguration {
    private static final int MAX_ATTEMPTS = 3;
    private static final int CONNECT_TIMEOUT = 5000;
    private static final Logger log = LoggerFactory.getLogger(J2CacheSpringRedisAutoConfiguration.class);

    @Bean(value={"j2CahceRedisConnectionFactory"})
    @ConditionalOnMissingBean(name={"j2CahceRedisConnectionFactory"})
    public JedisConnectionFactory j2CahceRedisConnectionFactory(J2CacheConfig j2CacheConfig) {
        int port;
        String[] host;
        Properties l2CacheProperties = j2CacheConfig.getL2CacheProperties();
        String hosts = l2CacheProperties.getProperty("hosts");
        String mode = l2CacheProperties.getProperty("mode");
        String clusterName = l2CacheProperties.getProperty("cluster_name");
        String password = l2CacheProperties.getProperty("password");
        int database = Integer.parseInt(l2CacheProperties.getProperty("database"));
        JedisConnectionFactory connectionFactory = null;
        JedisPoolConfig config = RedisUtils.newPoolConfig((Properties)l2CacheProperties, null);
        ArrayList<RedisNode> nodes = new ArrayList<RedisNode>();
        for (String node : hosts.split(",")) {
            String[] s = node.split(":");
            host = s[0];
            port = s.length > 1 ? Integer.parseInt(s[1]) : 6379;
            RedisNode n = new RedisNode((String)host, port);
            nodes.add(n);
        }
        RedisPassword paw = RedisPassword.none();
        if (!StringUtils.isEmpty((Object)password)) {
            paw = RedisPassword.of((String)password);
        }
        switch (mode) {
            case "sentinel": {
                RedisSentinelConfiguration sentinel = new RedisSentinelConfiguration();
                sentinel.setDatabase(database);
                sentinel.setPassword(paw);
                sentinel.setMaster(clusterName);
                sentinel.setSentinels(nodes);
                connectionFactory = new JedisConnectionFactory(sentinel, config);
                break;
            }
            case "cluster": {
                RedisClusterConfiguration cluster = new RedisClusterConfiguration();
                cluster.setClusterNodes(nodes);
                cluster.setMaxRedirects(3);
                cluster.setPassword(paw);
                connectionFactory = new JedisConnectionFactory(cluster, config);
                break;
            }
            case "sharded": {
                try {
                    host = hosts.split(",");
                    port = host.length;
                    int n = 0;
                    if (n >= port) break;
                    String node = host[n];
                    connectionFactory = new JedisConnectionFactory(new JedisShardInfo(new URI(node)));
                    break;
                }
                catch (URISyntaxException e) {
                    throw new JedisConnectionException((Throwable)e);
                }
            }
            default: {
                Iterator iterator = nodes.iterator();
                if (iterator.hasNext()) {
                    RedisNode node = (RedisNode)iterator.next();
                    String host2 = node.getHost();
                    int port2 = node.getPort();
                    RedisStandaloneConfiguration single = new RedisStandaloneConfiguration(host2, port2);
                    single.setDatabase(database);
                    single.setPassword(paw);
                    JedisClientConfiguration.JedisClientConfigurationBuilder clientConfiguration = JedisClientConfiguration.builder();
                    clientConfiguration.usePooling().poolConfig((GenericObjectPoolConfig)config);
                    clientConfiguration.connectTimeout(Duration.ofMillis(5000L));
                    connectionFactory = new JedisConnectionFactory(single, clientConfiguration.build());
                }
                if ("single".equalsIgnoreCase(mode)) break;
                log.warn("Redis mode [" + mode + "] not defined. Using 'single'.");
            }
        }
        return connectionFactory;
    }

    @Bean(value={"j2CacheRedisTemplate"})
    @ConditionalOnBean(name={"j2CahceRedisConnectionFactory"})
    public RedisTemplate<String, Serializable> j2CacheRedisTemplate(JedisConnectionFactory j2CahceRedisConnectionFactory) {
        RedisTemplate template = new RedisTemplate();
        template.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setDefaultSerializer((RedisSerializer)new J2CacheSerializer());
        template.setConnectionFactory((RedisConnectionFactory)j2CahceRedisConnectionFactory);
        return template;
    }

    @Bean(value={"j2CacheRedisMessageListenerContainer"})
    @ConditionalOnBean(name={"j2CahceRedisConnectionFactory"})
    RedisMessageListenerContainer container(JedisConnectionFactory j2CahceRedisConnectionFactory) {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory((RedisConnectionFactory)j2CahceRedisConnectionFactory);
        return container;
    }
}

