/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.cache.support.redis;

import java.io.Serializable;
import java.util.Properties;
import net.oschina.j2cache.ClusterPolicy;
import net.oschina.j2cache.Command;
import net.oschina.j2cache.cache.support.redis.SpringRedisMessageListener;
import net.oschina.j2cache.cache.support.util.SpringUtil;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;

public class SpringRedisPubSubPolicy
implements ClusterPolicy {
    private RedisConnectionFactory redisConnectionFactory;
    private RedisTemplate<String, Serializable> redisTemplate;
    private String channel = "j2cache_channel";

    public void connect(Properties props) {
        String channel_name = props.getProperty("jgroups.channel.name");
        if (channel_name == null || channel_name.isEmpty()) {
            this.channel = channel_name;
        }
        this.redisConnectionFactory = SpringUtil.getBean(RedisConnectionFactory.class);
        this.redisTemplate = SpringUtil.getBean("j2CacheRedisTemplate", RedisTemplate.class);
        RedisMessageListenerContainer listenerContainer = new RedisMessageListenerContainer();
        listenerContainer.setConnectionFactory(this.redisConnectionFactory);
        listenerContainer.addMessageListener((MessageListener)new SpringRedisMessageListener(this, this.channel), (Topic)new PatternTopic(this.channel));
    }

    public void sendEvictCmd(String region, String ... keys) {
        Command cmd = new Command(2, region, keys);
        this.redisTemplate.convertAndSend(this.channel, (Object)cmd.jsonBytes());
    }

    public void sendClearCmd(String region) {
        Command cmd = new Command(3, region, new String[]{""});
        this.redisTemplate.convertAndSend(this.channel, (Object)cmd.jsonBytes());
    }

    public void disconnect() {
        this.redisTemplate.convertAndSend(this.channel, (Object)Command.quit().jsonBytes());
    }
}

