/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.cache.support.redis;

import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import net.oschina.j2cache.Cache;
import net.oschina.j2cache.CacheChannel;
import net.oschina.j2cache.CacheExpiredListener;
import net.oschina.j2cache.CacheProvider;
import net.oschina.j2cache.cache.support.redis.SpringRedisCache;
import net.oschina.j2cache.cache.support.util.SpringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;

public class SpringRedisProvider
implements CacheProvider {
    private static final Logger log = LoggerFactory.getLogger(SpringRedisProvider.class);
    @Autowired
    private RedisTemplate<String, Serializable> redisTemplate;
    private String namespace = "j2cache";
    protected ConcurrentHashMap<String, SpringRedisCache> caches = new ConcurrentHashMap();

    public SpringRedisProvider() {
        this.redisTemplate = SpringUtil.getBean("j2CacheRedisTemplate", RedisTemplate.class);
    }

    public String name() {
        return "redis";
    }

    public int level() {
        return 2;
    }

    public Collection<CacheChannel.Region> regions() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Cache buildCache(String region, CacheExpiredListener listener) {
        SpringRedisCache cache = this.caches.get(region);
        if (cache != null) return cache;
        Class<SpringRedisProvider> clazz = SpringRedisProvider.class;
        synchronized (SpringRedisProvider.class) {
            if (cache != null) return cache;
            cache = new SpringRedisCache(this.namespace, region, this.redisTemplate);
            this.caches.put(region, cache);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return cache;
        }
    }

    public Cache buildCache(String region, long timeToLiveInSeconds, CacheExpiredListener listener) {
        return this.buildCache(region, listener);
    }

    public void start(Properties props) {
        this.namespace = props.getProperty("namespace");
        if (this.redisTemplate == null) {
            log.error("redisTemplate \u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u6709\u914d\u7f6espring redis!");
        }
    }

    public void stop() {
    }
}

