/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.cache.support.redis;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.oschina.j2cache.Level2Cache;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;

public class SpringRedisCache
implements Level2Cache {
    private String namespace;
    private String region;
    private RedisTemplate<String, Serializable> redisTemplate;

    public SpringRedisCache(String namespace, String region, RedisTemplate<String, Serializable> redisTemplate) {
        if (region == null || region.isEmpty()) {
            region = "_";
        }
        this.namespace = namespace;
        this.redisTemplate = redisTemplate;
        this.region = this.getRegionName(region);
    }

    private String getRegionName(String region) {
        if (this.namespace != null && !this.namespace.isEmpty()) {
            region = this.namespace + ":" + region;
        }
        return region;
    }

    public void clear() {
        this.redisTemplate.opsForHash().delete((Object)this.region, new Object[0]);
    }

    public Serializable get(String key) {
        Object value = this.redisTemplate.opsForHash().get((Object)this.region, (Object)key);
        if (value == null) {
            return null;
        }
        return (Serializable)value;
    }

    public Map<String, Object> get(Collection<String> keys) {
        HashMap<String, Object> map = new HashMap<String, Object>(keys.size());
        for (String k : keys) {
            Object value = this.redisTemplate.opsForHash().get((Object)this.region, (Object)k);
            if (value != null) {
                map.put(k, (Serializable)value);
                continue;
            }
            map.put(k, null);
        }
        return map;
    }

    public boolean exists(String key) {
        return this.redisTemplate.opsForHash().hasKey((Object)this.region, (Object)key);
    }

    public void put(String key, Object value) {
        this.redisTemplate.opsForHash().put((Object)this.region, (Object)key, value);
    }

    public void put(Map<String, Object> elements) {
        HashMap map = new HashMap(elements.size());
        elements.forEach((k, v) -> map.put(k, v));
        this.redisTemplate.opsForHash().putAll((Object)this.region, map);
    }

    public void evict(String ... keys) {
        this.redisTemplate.opsForHash().delete((Object)this.region, (Object[])keys);
    }

    public Collection<String> keys() {
        Set list = this.redisTemplate.opsForHash().keys((Object)this.region);
        ArrayList<String> keys = new ArrayList<String>(list.size());
        for (Object object : list) {
            keys.add((String)object);
        }
        return keys;
    }

    public byte[] getBytes(final String key) {
        return (byte[])this.redisTemplate.opsForHash().getOperations().execute((RedisCallback)new RedisCallback<byte[]>(){

            public byte[] doInRedis(RedisConnection redis) {
                return redis.hGet(SpringRedisCache.this.region.getBytes(), key.getBytes());
            }
        });
    }

    public List<byte[]> getBytes(final Collection<String> keys) {
        return (List)this.redisTemplate.opsForHash().getOperations().execute((RedisCallback)new RedisCallback<List<byte[]>>(){

            public List<byte[]> doInRedis(RedisConnection redis) throws DataAccessException {
                byte[][] bytes = (byte[][])keys.stream().map(k -> k.getBytes()).toArray(x$0 -> new byte[x$0][]);
                return redis.hMGet(SpringRedisCache.this.region.getBytes(), bytes);
            }
        });
    }

    public void setBytes(Map<String, byte[]> bytes) {
        this.redisTemplate.opsForHash().putAll((Object)this.region, bytes);
    }

    public void setBytes(String key, byte[] bytes) {
        this.redisTemplate.opsForHash().put((Object)this.region, (Object)key, (Object)bytes);
    }
}

