/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.cache.support;

import java.io.Serializable;
import java.util.concurrent.Callable;
import net.oschina.j2cache.CacheChannel;
import net.oschina.j2cache.CacheObject;
import net.oschina.j2cache.J2Cache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.support.AbstractValueAdaptingCache;

public class J2CacheCache
extends AbstractValueAdaptingCache {
    private static Logger logger = LoggerFactory.getLogger(J2CacheCache.class);
    private CacheChannel cacheChannel = J2Cache.getChannel();
    private String j2CacheName = "j2cache";

    public J2CacheCache(String cacheName) {
        this(cacheName, true);
    }

    public J2CacheCache(String cacheName, boolean allowNullValues) {
        super(allowNullValues);
        this.j2CacheName = cacheName;
    }

    public String getName() {
        return this.j2CacheName;
    }

    public void setJ2CacheNmae(String name) {
        this.j2CacheName = name;
    }

    public Object getNativeCache() {
        return this.cacheChannel;
    }

    public <T> T get(Object key, Callable<T> valueLoader) {
        T value;
        try {
            value = valueLoader.call();
        }
        catch (Throwable ex) {
            throw new Cache.ValueRetrievalException(key, valueLoader, ex);
        }
        this.put(key, value);
        return value;
    }

    public void put(Object key, Object value) {
        this.cacheChannel.set(this.j2CacheName, String.valueOf(key), (Object)((Serializable)this.toStoreValue(value)));
    }

    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        if (!this.cacheChannel.exists(this.j2CacheName, String.valueOf(key))) {
            this.cacheChannel.set(this.j2CacheName, String.valueOf(key), (Object)((Serializable)value));
        }
        return this.get(key);
    }

    public void evict(Object key) {
        this.cacheChannel.evict(this.j2CacheName, new String[]{String.valueOf(key)});
    }

    public void clear() {
        this.cacheChannel.clear(this.j2CacheName);
    }

    protected Object lookup(Object key) {
        CacheObject cacheObject = this.cacheChannel.get(this.j2CacheName, String.valueOf(key));
        return this.getValueByCacheObject(cacheObject);
    }

    private Object getValueByCacheObject(CacheObject cacheObject) {
        if (cacheObject != null) {
            return cacheObject.getValue();
        }
        return null;
    }
}

