/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.cache.support.redis;

import java.io.Serializable;
import java.util.Properties;
import net.oschina.j2cache.ClusterPolicy;
import net.oschina.j2cache.Command;
import net.oschina.j2cache.cache.support.redis.SpringRedisMessageListener;
import net.oschina.j2cache.cache.support.util.SpringUtil;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;

public class SpringRedisPubSubPolicy
implements ClusterPolicy {
    private RedisTemplate<String, Serializable> redisTemplate;
    private String channel = "j2cache_channel";

    public void connect(Properties props) {
        String channel_name = props.getProperty("jgroups.channel.name");
        if (channel_name != null && !channel_name.isEmpty()) {
            this.channel = channel_name;
        }
        this.redisTemplate = SpringUtil.getBean("j2CacheRedisTemplate", RedisTemplate.class);
        RedisMessageListenerContainer listenerContainer = SpringUtil.getBean("j2CacheRedisMessageListenerContainer", RedisMessageListenerContainer.class);
        listenerContainer.addMessageListener((MessageListener)new SpringRedisMessageListener(this, this.channel), (Topic)new PatternTopic(this.channel));
    }

    public void sendEvictCmd(String region, String ... keys) {
        String com = new Command(2, region, keys).json();
        this.redisTemplate.convertAndSend(this.channel, (Object)com);
    }

    public void sendClearCmd(String region) {
        String com = new Command(3, region, new String[]{""}).json();
        this.redisTemplate.convertAndSend(this.channel, (Object)com);
    }

    public void disconnect() {
        this.redisTemplate.convertAndSend(this.channel, (Object)Command.quit().json());
    }
}

