/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.session;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.oschina.j2cache.session.FSTSerializer;

public class SessionObject
implements Serializable {
    public static final String KEY_CREATE_AT = "CREATED_AT";
    public static final String KEY_ACCESS_AT = "ACCESS_AT";
    private String id;
    private long created_at;
    private long access_at;
    private int maxInactiveInterval;
    private ConcurrentHashMap<String, Object> attributes = new ConcurrentHashMap();

    public SessionObject() {
    }

    public SessionObject(String session_id, List<String> keys, List<byte[]> datas) throws IOException, ClassNotFoundException {
        this.id = session_id;
        for (int i = 0; i < keys.size(); ++i) {
            String key = keys.get(i);
            if (KEY_CREATE_AT.equals(key)) {
                this.created_at = Long.parseLong(new String(datas.get(i)));
                continue;
            }
            if (KEY_ACCESS_AT.equals(key)) {
                this.access_at = Long.parseLong(new String(datas.get(i)));
                continue;
            }
            this.attributes.put(key, FSTSerializer.read(datas.get(i)));
        }
    }

    public Object get(String key) {
        return this.attributes.get(key);
    }

    public boolean containsKey(String key) {
        return this.attributes.containsKey(key);
    }

    public Object put(String key, Object value) {
        return this.attributes.put(key, value);
    }

    public Object remove(String key) {
        return this.attributes.remove(key);
    }

    public void clear() {
        this.attributes.clear();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public long getCreated_at() {
        return this.created_at;
    }

    public void setCreated_at(long created_at) {
        this.created_at = created_at;
        this.access_at = created_at;
    }

    public long getLastAccess_at() {
        return this.access_at;
    }

    public void setLastAccess_at(long access_at) {
        this.access_at = access_at;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public void setMaxInactiveInterval(int maxInactiveInterval) {
        this.maxInactiveInterval = maxInactiveInterval;
    }

    public ConcurrentHashMap<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(HashMap<String, Object> attributes) {
        this.attributes.putAll(attributes);
    }
}

