/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.session;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.oschina.j2cache.session.RedisClient;
import redis.clients.jedis.BinaryJedisCommands;

public class RedisCache {
    private String namespace;
    private RedisClient client;

    public RedisCache(String namespace, RedisClient client) {
        this.client = client;
        this.namespace = namespace;
    }

    private String getRegionName(String session_id) {
        if (this.namespace != null && !this.namespace.isEmpty()) {
            session_id = this.namespace + ":" + session_id;
        }
        return session_id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(String session_id, String key) {
        try {
            byte[] regionBytes = this.getRegionName(session_id).getBytes();
            byte[] byArray = this.client.get().hget(regionBytes, key.getBytes());
            return byArray;
        }
        finally {
            this.client.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<byte[]> getBytes(String session_id, Collection<String> keys) {
        try {
            byte[] regionBytes = this.getRegionName(session_id).getBytes();
            byte[][] bytes = (byte[][])keys.stream().map(k -> k.getBytes()).toArray(x$0 -> new byte[x$0][]);
            List list = this.client.get().hmget(regionBytes, bytes);
            return list;
        }
        finally {
            this.client.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBytes(String session_id, String key, byte[] bytes) {
        try {
            byte[] regionBytes = this.getRegionName(session_id).getBytes();
            this.client.get().hset(regionBytes, key.getBytes(), bytes);
        }
        finally {
            this.client.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBytes(String session_id, Map<String, byte[]> bytes, int expireInSeconds) {
        try {
            HashMap data = new HashMap();
            bytes.forEach((k, v) -> data.put(k.getBytes(), v));
            byte[] regionBytes = this.getRegionName(session_id).getBytes();
            BinaryJedisCommands jedis = this.client.get();
            jedis.hmset(regionBytes, data);
            jedis.expire(regionBytes, expireInSeconds);
        }
        finally {
            this.client.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String session_id) {
        try {
            byte[] regionBytes = this.getRegionName(session_id).getBytes();
            boolean bl = this.client.get().exists(regionBytes);
            return bl;
        }
        finally {
            this.client.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String session_id, String key) {
        try {
            byte[] regionBytes = this.getRegionName(session_id).getBytes();
            boolean bl = this.client.get().hexists(regionBytes, key.getBytes());
            return bl;
        }
        finally {
            this.client.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evict(String session_id, String ... keys) {
        if (keys == null || keys.length == 0) {
            return;
        }
        try {
            byte[] regionBytes = this.getRegionName(session_id).getBytes();
            byte[][] bytes = (byte[][])Arrays.stream(keys).map(k -> k.getBytes()).toArray(x$0 -> new byte[x$0][]);
            this.client.get().hdel(regionBytes, bytes);
        }
        finally {
            this.client.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long ttl(String session_id, int ttl) {
        try {
            byte[] regionBytes = this.getRegionName(session_id).getBytes();
            long l = this.client.get().expire(regionBytes, ttl);
            return l;
        }
        finally {
            this.client.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> keys(String session_id) {
        try {
            byte[] regionBytes = this.getRegionName(session_id).getBytes();
            List<String> list = this.client.get().hkeys(regionBytes).stream().map(bs -> new String((byte[])bs)).collect(Collectors.toList());
            return list;
        }
        finally {
            this.client.release();
        }
    }

    public void clear(String session_id) {
        try {
            byte[] regionBytes = this.getRegionName(session_id).getBytes();
            this.client.get().del(regionBytes);
        }
        finally {
            this.client.release();
        }
    }

    public void close() {
        try {
            this.client.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

