/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.session;

import java.io.IOException;
import java.util.Collections;
import java.util.Properties;
import java.util.UUID;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.oschina.j2cache.session.CacheFacade;
import net.oschina.j2cache.session.J2CacheSession;
import net.oschina.j2cache.session.SessionObject;

public class J2CacheSessionFilter
implements Filter {
    private CacheFacade g_cache;
    private String cookieName;
    private String cookiePath;
    private String cookieDomain;
    private int cookieMaxAge;

    public void init(FilterConfig config) {
        this.cookieName = config.getInitParameter("cookie.name");
        this.cookieDomain = config.getInitParameter("cookie.domain");
        this.cookiePath = config.getInitParameter("cookie.path");
        this.cookieMaxAge = Integer.parseInt(config.getInitParameter("session.maxAge"));
        Properties redisConf = new Properties();
        for (String name : Collections.list(config.getInitParameterNames())) {
            if (!name.startsWith("redis.")) continue;
            redisConf.setProperty(name.substring(6), config.getInitParameter(name));
        }
        int maxSizeInMemory = Integer.parseInt(config.getInitParameter("session.maxSizeInMemory"));
        this.g_cache = new CacheFacade(maxSizeInMemory, this.cookieMaxAge, redisConf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        J2CacheRequestWrapper j2cacheRequest = new J2CacheRequestWrapper(req, res);
        try {
            chain.doFilter((ServletRequest)j2cacheRequest, res);
        }
        finally {
            J2CacheSession session = (J2CacheSession)j2cacheRequest.getSession(false);
            if (session != null && !session.isNew()) {
                this.g_cache.updateSessionAccessTime(session.getSessionObject());
            }
        }
    }

    public void destroy() {
        this.g_cache.close();
    }

    public class J2CacheRequestWrapper
    extends HttpServletRequestWrapper {
        private HttpServletResponse response;
        private J2CacheSession session;

        public J2CacheRequestWrapper(ServletRequest req, ServletResponse res) {
            super((HttpServletRequest)req);
            this.response = (HttpServletResponse)res;
        }

        public HttpSession getSession(boolean create) {
            if (this.session == null) {
                String session_id;
                Cookie ssnCookie = this.getCookie(J2CacheSessionFilter.this.cookieName);
                if (ssnCookie != null) {
                    session_id = ssnCookie.getValue();
                    SessionObject ssnObject = J2CacheSessionFilter.this.g_cache.getSession(session_id);
                    if (ssnObject != null) {
                        this.session = new J2CacheSession(this.getServletContext(), session_id, J2CacheSessionFilter.this.g_cache);
                        this.session.setSessionObject(ssnObject);
                        this.session.setNew(false);
                    }
                }
                if (this.session == null && create) {
                    session_id = UUID.randomUUID().toString().replaceAll("-", "");
                    this.session = new J2CacheSession(this.getServletContext(), session_id, J2CacheSessionFilter.this.g_cache);
                    J2CacheSessionFilter.this.g_cache.saveSession(this.session.getSessionObject());
                    this.setCookie(J2CacheSessionFilter.this.cookieName, session_id);
                }
            }
            return this.session;
        }

        public HttpSession getSession() {
            return this.getSession(true);
        }

        private Cookie getCookie(String name) {
            Cookie[] cookies = ((HttpServletRequest)this.getRequest()).getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!cookie.getName().equalsIgnoreCase(name)) continue;
                    return cookie;
                }
            }
            return null;
        }

        private void setCookie(String name, String value) {
            Cookie cookie = new Cookie(name, value);
            cookie.setMaxAge(-1);
            cookie.setPath(J2CacheSessionFilter.this.cookiePath);
            if (J2CacheSessionFilter.this.cookieDomain != null && J2CacheSessionFilter.this.cookieDomain.trim().length() > 0) {
                cookie.setDomain(J2CacheSessionFilter.this.cookieDomain);
            }
            cookie.setHttpOnly(true);
            this.response.addCookie(cookie);
        }
    }
}

