/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.session;

import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import net.oschina.j2cache.session.CacheFacade;
import net.oschina.j2cache.session.SessionObject;

public class J2CacheSession
implements HttpSession {
    private SessionObject session;
    private boolean newSession = true;
    private final ServletContext servletContext;
    private CacheFacade cache;
    private volatile boolean invalid;

    public J2CacheSession(ServletContext servletContext, String id, CacheFacade cache) {
        this.servletContext = servletContext;
        this.cache = cache;
        this.session = new SessionObject();
        this.session.setId(id);
        this.session.setCreated_at(System.currentTimeMillis());
    }

    public SessionObject getSessionObject() {
        return this.session;
    }

    public void setSessionObject(SessionObject session) {
        this.session = session;
    }

    public long getCreationTime() {
        return this.session.getCreated_at();
    }

    public String getId() {
        return this.session.getId();
    }

    public long getLastAccessedTime() {
        return this.session.getLastAccess_at();
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setMaxInactiveInterval(int interval) {
        this.session.setMaxInactiveInterval(interval);
    }

    public int getMaxInactiveInterval() {
        return this.session.getMaxInactiveInterval();
    }

    public Enumeration<String> getAttributeNames() {
        this.checkValid();
        return this.session.getAttributes().keys();
    }

    public Object getAttribute(String name) {
        this.checkValid();
        return this.session.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.checkValid();
        this.session.put(name, value);
        this.cache.setSessionAttribute(this.session, name);
    }

    public void removeAttribute(String name) {
        this.checkValid();
        this.session.remove(name);
        this.cache.removeSessionAttribute(this.session, name);
    }

    public void invalidate() {
        this.invalid = true;
        this.session.getAttributes().clear();
        this.cache.deleteSession(this.getId());
    }

    public boolean isNew() {
        return this.newSession;
    }

    public void setNew(boolean isNew) {
        this.newSession = isNew;
    }

    protected void checkValid() throws IllegalStateException {
        if (this.invalid) {
            throw new IllegalStateException("http session has invalidate");
        }
    }

    @Deprecated
    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    @Deprecated
    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    @Deprecated
    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    @Deprecated
    public String[] getValueNames() {
        this.checkValid();
        return (String[])Collections.list(this.session.getAttributes().keys()).stream().toArray(String[]::new);
    }

    @Deprecated
    public HttpSessionContext getSessionContext() {
        return null;
    }
}

