/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.session;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;

public class FSTSerializer {
    private static final FSTConfiguration fstConfiguration = FSTConfiguration.getDefaultConfiguration();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] write(Object obj) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (FSTObjectOutput fOut = new FSTObjectOutput((OutputStream)out, fstConfiguration);){
            fOut.writeObject(obj);
            fOut.flush();
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static Object read(byte[] bytes) throws IOException, ClassNotFoundException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try (FSTObjectInput in = new FSTObjectInput((InputStream)new ByteArrayInputStream(bytes), fstConfiguration);){
            Object object = in.readObject();
            return object;
        }
    }

    static {
        fstConfiguration.setClassLoader(Thread.currentThread().getContextClassLoader());
    }
}

