/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.session;

import java.io.Serializable;
import java.util.Random;
import org.nustaq.serialization.FSTConfiguration;

public class Command
implements Serializable {
    private static final FSTConfiguration conf = FSTConfiguration.createJsonConfiguration();
    private static final int SRC_ID;
    public static final byte OPT_JOIN = 1;
    public static final byte OPT_DELETE_SESSION = 3;
    public static final byte OPT_QUIT = 4;
    private int src = SRC_ID;
    private int operator;
    private String session;
    private String key;

    private static int genRandomSrc() {
        long ct = System.currentTimeMillis();
        Random rnd_seed = new Random(ct);
        return (int)((long)(rnd_seed.nextInt(10000) * 1000) + ct % 1000L);
    }

    public Command(byte operator, String session, String key) {
        this.operator = operator;
        this.session = session;
        this.key = key;
    }

    public static final int LocalID() {
        return SRC_ID;
    }

    public static Command join() {
        return new Command(1, null, null);
    }

    public static Command quit() {
        return new Command(4, null, null);
    }

    public static Command parse(String data) {
        return (Command)conf.asObject(data.getBytes());
    }

    public boolean isLocal() {
        return this.src == SRC_ID;
    }

    public int getOperator() {
        return this.operator;
    }

    public String getKey() {
        return this.key;
    }

    public int getSrc() {
        return this.src;
    }

    public void setSrc(int src) {
        this.src = src;
    }

    public void setOperator(int operator) {
        this.operator = operator;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getSession() {
        return this.session;
    }

    public void setSession(String session) {
        this.session = session;
    }

    public String toString() {
        return conf.asJsonString((Object)this);
    }

    public static void main(String[] args) {
        Command cmd = new Command(1, "aerlkjasldfkjasldkjfas", "123");
        System.out.println(cmd);
        System.out.println(Command.parse(cmd.toString()));
    }

    static {
        conf.registerCrossPlatformClassMapping("cmd", Command.class.getName());
        SRC_ID = Command.genRandomSrc();
    }
}

