/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.session;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import java.util.concurrent.TimeUnit;
import net.oschina.j2cache.session.CacheExpiredListener;

public class CaffeineCache {
    private Cache<String, Object> cache;
    private int size;
    private int expire;

    public CaffeineCache(int size, int expire, CacheExpiredListener listener) {
        this.cache = Caffeine.newBuilder().maximumSize((long)size).expireAfterAccess((long)expire, TimeUnit.SECONDS).removalListener((k, v, cause) -> {
            if (cause != RemovalCause.EXPLICIT && cause != RemovalCause.REPLACED) {
                listener.notifyElementExpired((String)k);
            }
        }).build();
        this.size = size;
        this.expire = expire;
    }

    public Object get(String session_id) {
        return this.cache.getIfPresent((Object)session_id);
    }

    public void put(String session_id, Object value) {
        this.cache.put((Object)session_id, value);
    }

    public void evict(String session_id) {
        this.cache.invalidate((Object)session_id);
    }

    public void close() {
    }

    public int getSize() {
        return this.size;
    }

    public int getExpire() {
        return this.expire;
    }
}

