/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.session;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import net.oschina.j2cache.session.CacheExpiredListener;
import net.oschina.j2cache.session.CaffeineCache;
import net.oschina.j2cache.session.Command;
import net.oschina.j2cache.session.FSTSerializer;
import net.oschina.j2cache.session.RedisCache;
import net.oschina.j2cache.session.RedisClient;
import net.oschina.j2cache.session.RedisUtils;
import net.oschina.j2cache.session.SessionObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.exceptions.JedisConnectionException;

public class CacheFacade
extends JedisPubSub
implements Closeable,
AutoCloseable,
CacheExpiredListener {
    private static final Log log = LogFactory.getLog(CacheFacade.class);
    private static final Map<String, Object> _g_keyLocks = new ConcurrentHashMap<String, Object>();
    private CaffeineCache cache1;
    private RedisCache cache2;
    private RedisClient redisClient;
    private String pubsub_channel;

    public CacheFacade(int maxSizeInMemory, int maxAge, Properties redisConf) {
        this.cache1 = new CaffeineCache(maxSizeInMemory, maxAge, this);
        JedisPoolConfig poolConfig = RedisUtils.newPoolConfig(redisConf, null);
        String hosts = redisConf.getProperty("hosts");
        String mode = redisConf.getProperty("mode");
        String clusterName = redisConf.getProperty("cluster_name");
        String password = redisConf.getProperty("password");
        int database = Integer.parseInt(redisConf.getProperty("database"));
        this.pubsub_channel = redisConf.getProperty("channel");
        long ct = System.currentTimeMillis();
        this.redisClient = new RedisClient.Builder().mode(mode).hosts(hosts).password(password).cluster(clusterName).database(database).poolConfig(poolConfig).newClient();
        this.cache2 = new RedisCache(null, this.redisClient);
        this.publish(Command.join());
        Thread subscribeThread = new Thread(() -> {
            while (true) {
                try {
                    Jedis jedis = (Jedis)this.redisClient.get();
                    jedis.subscribe((JedisPubSub)this, new String[]{this.pubsub_channel});
                    log.info((Object)("Disconnect to redis channel: " + this.pubsub_channel));
                }
                catch (JedisConnectionException e) {
                    log.error((Object)"Failed connect to redis, reconnect it.", (Throwable)e);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ie) {
                        break;
                    }
                }
            }
        }, "RedisSubscribeThread");
        subscribeThread.setDaemon(true);
        subscribeThread.start();
        log.info((Object)("Connected to redis channel:" + this.pubsub_channel + ", time " + (System.currentTimeMillis() - ct) + " ms."));
    }

    public void publish(Command cmd) {
        try {
            Jedis jedis = (Jedis)this.redisClient.get();
            jedis.publish(this.pubsub_channel, cmd.toString());
        }
        finally {
            this.redisClient.release();
        }
    }

    public void onMessage(String channel, String message) {
        Command cmd = Command.parse(message);
        try {
            if (cmd == null || cmd.isLocal()) {
                return;
            }
            switch (cmd.getOperator()) {
                case 1: {
                    log.info((Object)("Server-" + cmd.getSrc() + " joined !"));
                    break;
                }
                case 3: {
                    this.cache1.evict(cmd.getSession());
                    log.debug((Object)("Received session clear command, session=" + cmd.getSession()));
                    break;
                }
                case 4: {
                    log.info((Object)("Server-" + cmd.getSrc() + " quit !"));
                    break;
                }
                default: {
                    log.warn((Object)("Unknown command type = " + cmd.getOperator()));
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to handle received command", (Throwable)e);
        }
    }

    @Override
    public void notifyElementExpired(String session_id) {
        this.publish(new Command(3, session_id, null));
    }

    @Override
    public void close() {
        try {
            this.publish(Command.quit());
            if (this.isSubscribed()) {
                this.unsubscribe();
            }
        }
        finally {
            this.cache1.close();
            this.cache2.close();
            try {
                this.redisClient.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionObject getSession(String session_id) {
        SessionObject session = (SessionObject)this.cache1.get(session_id);
        if (session != null) {
            return session;
        }
        Object object = _g_keyLocks.computeIfAbsent(session_id, v -> new Object());
        synchronized (object) {
            session = (SessionObject)this.cache1.get(session_id);
            if (session != null) {
                return session;
            }
            try {
                List<String> keys = this.cache2.keys(session_id);
                if (keys.size() == 0) {
                    SessionObject sessionObject = null;
                    return sessionObject;
                }
                List<byte[]> datas = this.cache2.getBytes(session_id, keys);
                session = new SessionObject(session_id, keys, datas);
                this.cache1.put(session_id, session);
            }
            catch (Exception e) {
                log.error((Object)"Failed to read session from j2cache", (Throwable)e);
            }
            finally {
                _g_keyLocks.remove(session_id);
            }
            return session;
        }
    }

    public void saveSession(final SessionObject session) {
        this.cache1.put(session.getId(), session);
        this.cache2.setBytes(session.getId(), (Map<String, byte[]>)new HashMap<String, byte[]>(){
            {
                this.put("CREATED_AT", String.valueOf(session.getCreated_at()).getBytes());
                this.put("ACCESS_AT", String.valueOf(session.getLastAccess_at()).getBytes());
                session.getAttributes().entrySet().forEach((? super T e) -> this.put(e.getKey(), FSTSerializer.write(e.getValue())));
            }
        }, this.cache1.getExpire());
    }

    public void updateSessionAccessTime(SessionObject session) {
        try {
            session.setLastAccess_at(System.currentTimeMillis());
            this.cache1.put(session.getId(), session);
            this.cache2.setBytes(session.getId(), "ACCESS_AT", String.valueOf(session.getLastAccess_at()).getBytes());
            this.cache2.ttl(session.getId(), this.cache1.getExpire());
        }
        finally {
            this.publish(new Command(3, session.getId(), null));
        }
    }

    public void setSessionAttribute(SessionObject session, String key) {
        try {
            this.cache1.put(session.getId(), session);
            this.cache2.setBytes(session.getId(), key, FSTSerializer.write(session.get(key)));
        }
        finally {
            this.publish(new Command(3, session.getId(), null));
        }
    }

    public void removeSessionAttribute(SessionObject session, String key) {
        try {
            this.cache1.put(session.getId(), session);
            this.cache2.evict(session.getId(), key);
        }
        finally {
            this.publish(new Command(3, session.getId(), null));
        }
    }

    public void deleteSession(String session_id) {
        try {
            this.cache1.evict(session_id);
            this.cache2.clear(session_id);
        }
        finally {
            this.publish(new Command(3, session_id, null));
        }
    }
}

