/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.mybatis;

import java.util.Collection;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.oschina.j2cache.CacheChannel;
import net.oschina.j2cache.J2Cache;
import org.apache.ibatis.cache.Cache;

public class J2CacheAdapter
implements Cache {
    private static final String DEFAULT_REGION = "default";
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private CacheChannel cache = J2Cache.getChannel();
    private String id;

    public J2CacheAdapter(String id) {
        if (id == null) {
            id = DEFAULT_REGION;
        }
        this.id = id;
    }

    public void setId(String id) {
        if (id == null) {
            id = DEFAULT_REGION;
        }
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void putObject(Object o, Object o1) {
        this.cache.set(this.id, o.toString(), o1);
    }

    public Object getObject(Object key) {
        return this.cache.get(this.id, key.toString(), new boolean[0]).getValue();
    }

    public Object removeObject(Object o) {
        Object obj = this.cache.get(this.id, o.toString(), new boolean[0]).getValue();
        if (obj != null) {
            this.cache.evict(this.id, new String[]{o.toString()});
        }
        return obj;
    }

    public void clear() {
        this.cache.clear(this.getId());
    }

    public int getSize() {
        Collection keys = this.cache.keys(this.getId());
        return keys != null ? keys.size() : 0;
    }

    public ReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }
}

