/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.hibernate4.strategy;

import net.oschina.j2cache.hibernate4.regions.J2CacheEntityRegion;
import net.oschina.j2cache.hibernate4.strategy.AbstractJ2CacheAccessStrategy;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.cfg.Settings;

public class NonStrictReadWriteJ2CacheEntityRegionAccessStrategy
extends AbstractJ2CacheAccessStrategy<J2CacheEntityRegion>
implements EntityRegionAccessStrategy {
    public NonStrictReadWriteJ2CacheEntityRegionAccessStrategy(J2CacheEntityRegion region, Settings settings) {
        super(region, settings);
    }

    public EntityRegion getRegion() {
        return (EntityRegion)super.region();
    }

    public Object get(Object key, long txTimestamp) throws CacheException {
        return ((J2CacheEntityRegion)this.region()).get(key);
    }

    @Override
    public boolean putFromLoad(Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) throws CacheException {
        if (minimalPutOverride && ((J2CacheEntityRegion)this.region()).contains(key)) {
            return false;
        }
        ((J2CacheEntityRegion)this.region()).put(key, value);
        return true;
    }

    public SoftLock lockItem(Object key, Object version) throws CacheException {
        return null;
    }

    public void unlockItem(Object key, SoftLock lock) throws CacheException {
        ((J2CacheEntityRegion)this.region()).remove(key);
    }

    public boolean insert(Object key, Object value, Object version) throws CacheException {
        return false;
    }

    public boolean afterInsert(Object key, Object value, Object version) throws CacheException {
        return false;
    }

    public boolean update(Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        this.remove(key);
        return false;
    }

    public boolean afterUpdate(Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) throws CacheException {
        this.unlockItem(key, lock);
        return false;
    }

    @Override
    public void remove(Object key) throws CacheException {
        ((J2CacheEntityRegion)this.region()).remove(key);
    }
}

