/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.hibernate4.regions;

import java.util.Properties;
import net.oschina.j2cache.CacheObject;
import net.oschina.j2cache.hibernate4.CacheRegion;
import net.oschina.j2cache.hibernate4.log.J2CacheMessageLogger;
import net.oschina.j2cache.hibernate4.regions.J2CacheDataRegion;
import net.oschina.j2cache.hibernate4.strategy.J2CacheAccessStrategyFactory;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.GeneralDataRegion;
import org.jboss.logging.Logger;

public class J2CacheGeneralDataRegion
extends J2CacheDataRegion
implements GeneralDataRegion {
    private static final J2CacheMessageLogger LOG = (J2CacheMessageLogger)Logger.getMessageLogger(J2CacheMessageLogger.class, (String)J2CacheGeneralDataRegion.class.getName());

    public J2CacheGeneralDataRegion(J2CacheAccessStrategyFactory accessStrategyFactory, CacheRegion underlyingCache, Properties properties) {
        super(accessStrategyFactory, underlyingCache, properties);
    }

    public Object get(Object key) throws CacheException {
        LOG.debugf("key: %s", key);
        if (key == null) {
            return null;
        }
        CacheObject value = this.getCache().get(key);
        if (value == null) {
            LOG.debugf("value for key %s is null", key);
            return null;
        }
        return value.getValue();
    }

    public void put(Object key, Object value) throws CacheException {
        LOG.debugf("key: %s value: %s", key, value);
        try {
            this.getCache().put(key, value);
        }
        catch (IllegalArgumentException e) {
            throw new CacheException((Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void evict(Object key) throws CacheException {
        try {
            this.getCache().evict(key);
        }
        catch (ClassCastException e) {
            throw new CacheException((Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void evictAll() throws CacheException {
        try {
            this.getCache().clear();
        }
        catch (IllegalStateException e) {
            throw new CacheException((Throwable)e);
        }
    }
}

