/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.hibernate4.regions;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.oschina.j2cache.CacheObject;
import net.oschina.j2cache.hibernate4.CacheRegion;
import net.oschina.j2cache.hibernate4.strategy.J2CacheAccessStrategyFactory;
import net.oschina.j2cache.hibernate4.util.Timestamper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.Region;

public abstract class J2CacheDataRegion
implements Region {
    private static final Log LOG = LogFactory.getLog(J2CacheDataRegion.class);
    private static final String CACHE_LOCK_TIMEOUT_PROPERTY = "hibernate.cache_lock_timeout";
    private static final int DEFAULT_CACHE_LOCK_TIMEOUT = 60000;
    private final CacheRegion cache;
    private final J2CacheAccessStrategyFactory accessStrategyFactory;
    private final int cacheLockTimeout;

    J2CacheDataRegion(J2CacheAccessStrategyFactory accessStrategyFactory, CacheRegion cache, Properties properties) {
        this.accessStrategyFactory = accessStrategyFactory;
        this.cache = cache;
        String timeout = properties.getProperty(CACHE_LOCK_TIMEOUT_PROPERTY, Integer.toString(60000));
        this.cacheLockTimeout = Timestamper.ONE_MS * Integer.decode(timeout);
    }

    protected CacheRegion getCache() {
        return this.cache;
    }

    public CacheRegion getJ2Cache() {
        return this.getCache();
    }

    protected J2CacheAccessStrategyFactory getAccessStrategyFactory() {
        return this.accessStrategyFactory;
    }

    public String getName() {
        return this.getCache().getName();
    }

    public void destroy() throws CacheException {
        try {
            this.getCache().clear();
        }
        catch (IllegalStateException e) {
            LOG.debug((Object)"This can happen if multiple frameworks both try to shutdown ehcache", (Throwable)e);
        }
    }

    public long getSizeInMemory() {
        return -1L;
    }

    public long getElementCountInMemory() {
        return -1L;
    }

    public long getElementCountOnDisk() {
        return -1L;
    }

    public Map toMap() {
        try {
            HashMap<Object, Object> result = new HashMap<Object, Object>();
            for (Object object : this.cache.keys()) {
                CacheObject e = this.cache.get(object);
                if (e == null) continue;
                result.put(object, e.getValue());
            }
            return result;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public long nextTimestamp() {
        return Timestamper.next();
    }

    public int getTimeout() {
        return this.cacheLockTimeout;
    }

    public boolean contains(Object key) {
        return false;
    }
}

