/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.hibernate4.nonstop;

import net.oschina.j2cache.hibernate4.log.J2CacheMessageLogger;
import net.oschina.j2cache.hibernate4.nonstop.NonStopCacheException;
import org.jboss.logging.Logger;

public final class HibernateNonstopCacheExceptionHandler {
    public static final String HIBERNATE_THROW_EXCEPTION_ON_TIMEOUT_PROPERTY = "J2Cache.hibernate.propagateNonStopCacheException";
    public static final String HIBERNATE_LOG_EXCEPTION_STACK_TRACE_PROPERTY = "J2Cache.hibernate.logNonStopCacheExceptionStackTrace";
    private static final J2CacheMessageLogger LOG = (J2CacheMessageLogger)Logger.getMessageLogger(J2CacheMessageLogger.class, (String)HibernateNonstopCacheExceptionHandler.class.getName());
    private static final HibernateNonstopCacheExceptionHandler INSTANCE = new HibernateNonstopCacheExceptionHandler();

    private HibernateNonstopCacheExceptionHandler() {
    }

    public static HibernateNonstopCacheExceptionHandler getInstance() {
        return INSTANCE;
    }

    public void handleNonstopCacheException(NonStopCacheException nonStopCacheException) {
        if (Boolean.getBoolean(HIBERNATE_THROW_EXCEPTION_ON_TIMEOUT_PROPERTY)) {
            throw nonStopCacheException;
        }
        if (Boolean.getBoolean(HIBERNATE_LOG_EXCEPTION_STACK_TRACE_PROPERTY)) {
            LOG.debug("Ignoring NonstopCacheException - " + nonStopCacheException.getMessage(), (Throwable)((Object)nonStopCacheException));
        } else {
            LOG.debug("Ignoring NonstopCacheException - " + nonStopCacheException.getMessage());
        }
    }
}

