/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.hibernate4;

import java.util.Properties;
import net.oschina.j2cache.CacheChannel;
import net.oschina.j2cache.hibernate4.CacheRegion;
import net.oschina.j2cache.hibernate4.J2CacheCacheRegion;
import net.oschina.j2cache.hibernate4.regions.J2CacheCollectionRegion;
import net.oschina.j2cache.hibernate4.regions.J2CacheEntityRegion;
import net.oschina.j2cache.hibernate4.regions.J2CacheNaturalIdRegion;
import net.oschina.j2cache.hibernate4.regions.J2CacheQueryResultsRegion;
import net.oschina.j2cache.hibernate4.regions.J2CacheTimestampsRegion;
import net.oschina.j2cache.hibernate4.strategy.J2CacheAccessStrategyFactory;
import net.oschina.j2cache.hibernate4.strategy.J2CacheAccessStrategyFactoryImpl;
import net.oschina.j2cache.hibernate4.strategy.NonstopAccessStrategyFactory;
import net.oschina.j2cache.hibernate4.util.Timestamper;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.CollectionRegion;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.TimestampsRegion;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cfg.Settings;

abstract class AbstractJ2CacheRegionFactory
implements RegionFactory {
    protected Settings settings;
    protected CacheChannel channel;
    protected final J2CacheAccessStrategyFactory accessStrategyFactory = new NonstopAccessStrategyFactory(new J2CacheAccessStrategyFactoryImpl());

    AbstractJ2CacheRegionFactory() {
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return true;
    }

    public long nextTimestamp() {
        return Timestamper.next();
    }

    public EntityRegion buildEntityRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        return new J2CacheEntityRegion(this.accessStrategyFactory, this.getCache(regionName), this.settings, metadata, properties);
    }

    public NaturalIdRegion buildNaturalIdRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        return new J2CacheNaturalIdRegion(this.accessStrategyFactory, this.getCache(regionName), this.settings, metadata, properties);
    }

    public CollectionRegion buildCollectionRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        return new J2CacheCollectionRegion(this.accessStrategyFactory, this.getCache(regionName), this.settings, metadata, properties);
    }

    public QueryResultsRegion buildQueryResultsRegion(String regionName, Properties properties) throws CacheException {
        return new J2CacheQueryResultsRegion(this.accessStrategyFactory, this.getCache(regionName), properties);
    }

    public TimestampsRegion buildTimestampsRegion(String regionName, Properties properties) throws CacheException {
        return new J2CacheTimestampsRegion(this.accessStrategyFactory, this.getCache(regionName), properties);
    }

    private CacheRegion getCache(String name) throws CacheException {
        return new J2CacheCacheRegion(this.channel, name);
    }

    public AccessType getDefaultAccessType() {
        return AccessType.READ_WRITE;
    }

    public void setChannel(CacheChannel channel) {
        this.channel = channel;
    }
}

