/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.hibernate3;

import java.util.Properties;
import net.oschina.j2cache.CacheChannel;
import net.oschina.j2cache.J2Cache;
import net.oschina.j2cache.hibernate3.J2CacheRegion;
import org.hibernate.cache.CacheDataDescription;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CollectionRegion;
import org.hibernate.cache.EntityRegion;
import org.hibernate.cache.QueryResultsRegion;
import org.hibernate.cache.RegionFactory;
import org.hibernate.cache.Timestamper;
import org.hibernate.cache.TimestampsRegion;
import org.hibernate.cfg.Settings;

public class J2CacheRegionFactory
implements RegionFactory {
    private CacheChannel channel = J2Cache.getChannel();

    public CollectionRegion buildCollectionRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        return new J2CacheRegion.Collection(regionName, this.channel);
    }

    public EntityRegion buildEntityRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        return new J2CacheRegion.Entity(regionName, this.channel);
    }

    public QueryResultsRegion buildQueryResultsRegion(String regionName, Properties properties) throws CacheException {
        return new J2CacheRegion.QueryResults(regionName, this.channel);
    }

    public TimestampsRegion buildTimestampsRegion(String regionName, Properties properties) throws CacheException {
        return new J2CacheRegion.Timestamps(regionName, this.channel);
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return true;
    }

    public long nextTimestamp() {
        return Timestamper.next();
    }

    public void start(Settings settings, Properties properties) throws CacheException {
    }

    public void stop() {
        this.channel.close();
    }
}

