/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.spring.boot.autoconfigure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

@ConfigurationProperties(prefix="mybatis")
public class MybatisProperties {
    private static final String COMMON_SQL_CLASSPATH = "fastmybatis/commonSql.xml";
    public static final String MYBATIS_PREFIX = "mybatis";
    private String configLocation;
    private String[] mapperLocations;
    private String typeAliasesPackage;
    private String typeHandlersPackage;
    private boolean checkConfigLocation = false;
    private ExecutorType executorType;
    private Properties configurationProperties;
    @NestedConfigurationProperty
    private Configuration configuration;
    private boolean camel2underline = Boolean.TRUE;
    private int mapperExecutorPoolSize = 20;
    private String templateClasspath;
    private String commonSqlClasspath = "fastmybatis/commonSql.xml";
    private String mapperSaveDir;
    private String basePackage;
    private String globalVmLocation;
    private Map<String, String> fill;
    private String logicDeleteValue = "1";
    private String logicNotDeleteValue = "0";
    private boolean hotDeploy;
    private boolean ignoreLogicDeleteWithAssociation;
    private boolean ignoreEmptyString = true;
    private boolean emptyStringWithTrim = true;
    private List<String> ignoreUpdateColumns = new ArrayList<String>(8);

    public boolean isCamel2underline() {
        return this.camel2underline;
    }

    public void setCamel2underline(boolean camel2underline) {
        this.camel2underline = camel2underline;
    }

    public int getMapperExecutorPoolSize() {
        return this.mapperExecutorPoolSize;
    }

    public void setMapperExecutorPoolSize(int mapperExecutorPoolSize) {
        this.mapperExecutorPoolSize = mapperExecutorPoolSize;
    }

    public String getTemplateClasspath() {
        return this.templateClasspath;
    }

    public void setTemplateClasspath(String templateClasspath) {
        this.templateClasspath = templateClasspath;
    }

    public String getCommonSqlClasspath() {
        return this.commonSqlClasspath;
    }

    public void setCommonSqlClasspath(String commonSqlClasspath) {
        this.commonSqlClasspath = commonSqlClasspath;
    }

    public String getMapperSaveDir() {
        return this.mapperSaveDir;
    }

    public void setMapperSaveDir(String mapperSaveDir) {
        this.mapperSaveDir = mapperSaveDir;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public String getConfigLocation() {
        return this.configLocation;
    }

    public void setConfigLocation(String configLocation) {
        this.configLocation = configLocation;
    }

    @Deprecated
    public String getConfig() {
        return this.configLocation;
    }

    @Deprecated
    public void setConfig(String config) {
        this.configLocation = config;
    }

    public String[] getMapperLocations() {
        return this.mapperLocations;
    }

    public void setMapperLocations(String[] mapperLocations) {
        this.mapperLocations = mapperLocations;
    }

    public String getTypeHandlersPackage() {
        return this.typeHandlersPackage;
    }

    public void setTypeHandlersPackage(String typeHandlersPackage) {
        this.typeHandlersPackage = typeHandlersPackage;
    }

    public String getTypeAliasesPackage() {
        return this.typeAliasesPackage;
    }

    public void setTypeAliasesPackage(String typeAliasesPackage) {
        this.typeAliasesPackage = typeAliasesPackage;
    }

    public boolean isCheckConfigLocation() {
        return this.checkConfigLocation;
    }

    public void setCheckConfigLocation(boolean checkConfigLocation) {
        this.checkConfigLocation = checkConfigLocation;
    }

    public ExecutorType getExecutorType() {
        return this.executorType;
    }

    public void setExecutorType(ExecutorType executorType) {
        this.executorType = executorType;
    }

    public Properties getConfigurationProperties() {
        return this.configurationProperties;
    }

    public void setConfigurationProperties(Properties configurationProperties) {
        this.configurationProperties = configurationProperties;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Resource[] resolveMapperLocations() {
        PathMatchingResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        if (this.mapperLocations != null) {
            for (String mapperLocation : this.mapperLocations) {
                try {
                    Resource[] mappers = resourceResolver.getResources(mapperLocation);
                    resources.addAll(Arrays.asList(mappers));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return resources.toArray(new Resource[resources.size()]);
    }

    public Map<String, String> getFill() {
        return this.fill;
    }

    public void setFill(Map<String, String> fill) {
        this.fill = fill;
    }

    public String getLogicDeleteValue() {
        return this.logicDeleteValue;
    }

    public void setLogicDeleteValue(String logicDeleteValue) {
        this.logicDeleteValue = logicDeleteValue;
    }

    public String getLogicNotDeleteValue() {
        return this.logicNotDeleteValue;
    }

    public void setLogicNotDeleteValue(String logicNotDeleteValue) {
        this.logicNotDeleteValue = logicNotDeleteValue;
    }

    public String getGlobalVmLocation() {
        return this.globalVmLocation;
    }

    public void setGlobalVmLocation(String globalVmLocation) {
        this.globalVmLocation = globalVmLocation;
    }

    public boolean isHotDeploy() {
        return this.hotDeploy;
    }

    public void setHotDeploy(boolean hotDeploy) {
        this.hotDeploy = hotDeploy;
    }

    public boolean getHotDeploy() {
        return this.hotDeploy;
    }

    public List<String> getIgnoreUpdateColumns() {
        return this.ignoreUpdateColumns;
    }

    public void setIgnoreUpdateColumns(List<String> ignoreUpdateColumns) {
        this.ignoreUpdateColumns = ignoreUpdateColumns;
    }

    public boolean getIgnoreLogicDeleteWithAssociation() {
        return this.ignoreLogicDeleteWithAssociation;
    }

    public void setIgnoreLogicDeleteWithAssociation(boolean ignoreLogicDeleteWithAssociation) {
        this.ignoreLogicDeleteWithAssociation = ignoreLogicDeleteWithAssociation;
    }

    public boolean isIgnoreLogicDeleteWithAssociation() {
        return this.ignoreLogicDeleteWithAssociation;
    }

    public boolean isIgnoreEmptyString() {
        return this.ignoreEmptyString;
    }

    public void setIgnoreEmptyString(boolean ignoreEmptyString) {
        this.ignoreEmptyString = ignoreEmptyString;
    }

    public boolean isEmptyStringWithTrim() {
        return this.emptyStringWithTrim;
    }

    public void setEmptyStringWithTrim(boolean emptyStringWithTrim) {
        this.emptyStringWithTrim = emptyStringWithTrim;
    }
}

