/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.solon.integration;

import com.gitee.fastmybatis.core.FastmybatisConfig;
import com.gitee.fastmybatis.core.ext.MapperLocationsBuilder;
import com.gitee.fastmybatis.core.ext.MyBatisResource;
import com.gitee.fastmybatis.core.util.DbUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.solon.integration.MybatisAdapterDefault;
import org.noear.solon.Utils;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.Props;
import org.noear.solon.core.VarHolder;

public class MybatisAdapterFastmybatis
extends MybatisAdapterDefault {
    protected FastmybatisConfig globalConfig;
    protected MapperLocationsBuilder mapperLocationsBuilder;
    protected List<String> mapperResources;

    protected MybatisAdapterFastmybatis(BeanWrap dsWrap) {
        super(dsWrap);
    }

    protected MybatisAdapterFastmybatis(BeanWrap dsWrap, Props dsProps) {
        super(dsWrap, dsProps);
    }

    protected void initConfiguration(Environment environment) {
        this.config = new Configuration(environment);
        Props cfgProps = this.dsProps.getProp("configuration");
        if (cfgProps.size() > 0) {
            Utils.injectProperties((Object)this.config, (Properties)cfgProps);
        }
        this.globalConfig = new FastmybatisConfig();
        Props globalProps = this.dsProps.getProp("globalConfig");
        if (globalProps.size() > 0) {
            Utils.injectProperties((Object)this.globalConfig, (Properties)globalProps);
        }
        this.mapperLocationsBuilder = new MapperLocationsBuilder(this.globalConfig);
        this.mapperResources = new ArrayList<String>(8);
    }

    protected void addMapperByXml(String uri) {
        this.mapperResources.add(uri);
    }

    public FastmybatisConfig getGlobalConfig() {
        return this.globalConfig;
    }

    public SqlSessionFactory getFactory() {
        if (this.factory == null) {
            try {
                this.initXml();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.factory = this.factoryBuilder.build(this.getConfiguration());
        }
        return this.factory;
    }

    protected void initXml() throws IOException {
        MyBatisResource[] allMybatisMapperResources;
        ArrayList<MyBatisResource> myBatisResources = new ArrayList<MyBatisResource>(16);
        if (this.mapperResources != null) {
            for (String mapperResource : this.mapperResources) {
                MyBatisResource myBatisResource = MyBatisResource.buildFromClasspath((String)mapperResource);
                myBatisResources.add(myBatisResource);
            }
        }
        Objects.requireNonNull(this.globalConfig);
        DataSource dataSource = this.getDataSource();
        String dialect = DbUtil.getDialect((DataSource)dataSource);
        Collection mapperClasses = this.config.getMapperRegistry().getMappers();
        for (MyBatisResource myBatisResource : allMybatisMapperResources = this.mapperLocationsBuilder.build(new HashSet(mapperClasses), myBatisResources, dialect)) {
            try (InputStream inputStream = myBatisResource.getInputStream();){
                String resource = myBatisResource.getFilepath();
                if (resource == null) {
                    resource = myBatisResource.getFilename();
                }
                XMLMapperBuilder mapperParser = new XMLMapperBuilder(inputStream, this.config, resource, this.config.getSqlFragments());
                mapperParser.parse();
            }
        }
    }

    public void injectTo(VarHolder varH) {
        super.injectTo(varH);
        if (FastmybatisConfig.class.isAssignableFrom(varH.getType())) {
            varH.setValue((Object)this.getGlobalConfig());
            return;
        }
    }
}

