/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.util;

import com.gitee.fastmybatis.core.FastmybatisConstants;
import com.gitee.fastmybatis.core.ext.exception.MapperFileException;
import java.io.InputStream;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class MybatisFileUtil {
    private static final Log LOG = LogFactory.getLog(MybatisFileUtil.class);

    public static String getExtFileContent(InputStream in) throws DocumentException {
        Document document = MybatisFileUtil.buildSAXReader().read(in);
        Element mapperNode = document.getRootElement();
        return MybatisFileUtil.trimMapperNode(mapperNode);
    }

    public static String trimMapperNode(Element mapperNode) {
        String rootNodeName = mapperNode.getName();
        if (!"mapper".equals(rootNodeName)) {
            throw new MapperFileException("mapper\u6587\u4ef6\u5fc5\u987b\u542b\u6709<mapper>\u8282\u70b9,\u662f\u5426\u7f3a\u5c11<mapper></mapper>?");
        }
        mapperNode.remove(FastmybatisConstants.NAMESPACE);
        String xml = mapperNode.asXML();
        xml = xml.replace("<mapper>", "").replace("</mapper>", "").replace("<mapper/>", "");
        return xml;
    }

    private static SAXReader buildSAXReader() {
        SAXReader reader = new SAXReader();
        reader.setEncoding("UTF-8");
        try {
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (SAXException e) {
            LOG.error("reader.setFeature fail by ", (Throwable)e);
        }
        return reader;
    }
}

