/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.util;

import com.gitee.fastmybatis.core.ext.code.util.FieldUtil;
import com.gitee.fastmybatis.core.handler.BaseEnum;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;

public class MyBeanUtil {
    private static final Log logger = LogFactory.getLog(MyBeanUtil.class);
    private static final String PREFIX_GET = "get";
    private static final String PREFIX_SET = "set";
    private static final String PREFIX_IS = "is";
    private static final String GET_CLASS_NAME = "getClass";

    public static void copyPropertiesIgnoreNull(Object source, Object target) {
        MyBeanUtil.copyProperties(source, target, true);
    }

    private static void copyPropertiesForMap(Map<String, Object> source, Object target, boolean ignoreNullValue) {
        Objects.requireNonNull(source, "Source must not be null");
        Objects.requireNonNull(target, "Target must not be null");
        Method[] targetMethods = target.getClass().getMethods();
        Map<String, MethodBean> setMethodMap = MyBeanUtil.buildSetMethodMap(targetMethods);
        Set<String> keys = source.keySet();
        try {
            for (String column : keys) {
                Object sourceFieldValue = source.get(column);
                if (ignoreNullValue && sourceFieldValue == null) continue;
                MethodBean methodBean = setMethodMap.get(column);
                if (methodBean == null) {
                    String fieldName = FieldUtil.underlineToCamel(column);
                    methodBean = setMethodMap.get(fieldName);
                }
                if (methodBean == null) continue;
                Class<?> paramType = methodBean.getParamType();
                Object targetVal = MyBeanUtil.parseValue(sourceFieldValue, paramType);
                Method targetMethod = methodBean.getMethod();
                MyBeanUtil.setValue(targetMethod, target, targetVal);
            }
        }
        catch (Exception e) {
            logger.error("copyPropertiesForMap error, source=" + source, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static void copyProperties(Object source, Object target, boolean ignoreNullValue) {
        Objects.requireNonNull(source, "Source must not be null");
        Objects.requireNonNull(target, "Target must not be null");
        if (source instanceof Map) {
            MyBeanUtil.copyPropertiesForMap((Map)source, target, ignoreNullValue);
            return;
        }
        Method[] sourceMethods = source.getClass().getMethods();
        Method[] targetMethods = target.getClass().getMethods();
        Map<String, MethodBean> setMethodMap = MyBeanUtil.buildSetMethodMap(targetMethods);
        try {
            for (Method method : sourceMethods) {
                MethodBean methodBean;
                if (!MyBeanUtil.isGetMethod(method)) continue;
                String methodName = method.getName();
                Class<?> returnType = method.getReturnType();
                String sourceFieldName = MyBeanUtil.buildFieldName(methodName);
                Object sourceFieldValue = method.invoke(source, new Object[0]);
                if (ignoreNullValue && sourceFieldValue == null || (methodBean = setMethodMap.get(sourceFieldName)) == null) continue;
                Class<?> paramType = methodBean.getParamType();
                Method targetMethod = methodBean.getMethod();
                if (paramType != returnType) continue;
                MyBeanUtil.setValue(targetMethod, target, sourceFieldValue);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("copyProperties error", e);
        }
    }

    private static Map<String, MethodBean> buildSetMethodMap(Method[] methods) {
        return Arrays.stream(methods).filter(MyBeanUtil::isSetMethod).collect(Collectors.toMap(method -> MyBeanUtil.buildFieldName(method.getName()), method -> {
            Class<?> parameterType = method.getParameterTypes()[0];
            return new MethodBean((Method)method, parameterType);
        }));
    }

    private static void setValue(Method method, Object obj, Object value) throws InvocationTargetException, IllegalAccessException {
        method.invoke(obj, value);
    }

    public static void copyProperties(Object source, Object target) {
        Objects.requireNonNull(source, "Source must not be null");
        Objects.requireNonNull(target, "Target must not be null");
        MyBeanUtil.copyProperties(source, target, false);
    }

    public static <T> List<T> copyBean(List<?> from, Class<T> toClass) {
        if (from == null || from.isEmpty()) {
            return new ArrayList();
        }
        return from.stream().filter(Objects::nonNull).map(source -> MyBeanUtil.copyBean(source, toClass)).collect(Collectors.toList());
    }

    public static <T> T copyBean(Object from, Class<T> toClass) {
        if (from == null) {
            return null;
        }
        T target = MyBeanUtil.newInstance(toClass);
        MyBeanUtil.copyProperties(from, target);
        return target;
    }

    private static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("create instance error", e);
        }
    }

    public static Map<String, Object> pojoToMap(Object pojo) {
        if (pojo == null) {
            return Collections.emptyMap();
        }
        Method[] methods = pojo.getClass().getMethods();
        HashMap<String, Object> map = new HashMap<String, Object>(methods.length * 2);
        try {
            for (Method method : methods) {
                if (!MyBeanUtil.isGetMethod(method)) continue;
                String methodName = method.getName();
                String fieldName = MyBeanUtil.buildFieldName(methodName);
                Object value = method.invoke(pojo, new Object[0]);
                map.put(fieldName, value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("pojoToMap\u5931\u8d25", e);
        }
        return map;
    }

    private static String buildFieldName(String methodName) {
        if (methodName.startsWith(PREFIX_IS)) {
            return methodName.substring(2, 3).toLowerCase() + methodName.substring(3);
        }
        return methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
    }

    private static boolean isGetMethod(Method method) {
        Class<?> returnType = method.getReturnType();
        if (returnType == Void.TYPE) {
            return false;
        }
        String methodName = method.getName();
        if (GET_CLASS_NAME.equals(methodName)) {
            return false;
        }
        boolean isBooleanType = returnType == Boolean.TYPE || returnType == Boolean.class;
        return methodName.startsWith(PREFIX_GET) || isBooleanType && methodName.startsWith(PREFIX_IS);
    }

    private static boolean isSetMethod(Method method) {
        return method.getName().startsWith(PREFIX_SET) && method.getParameterTypes().length == 1;
    }

    public static <T> T parseValue(Object value, Class<T> valClass) {
        if (value == null) {
            return null;
        }
        if (valClass == Object.class) {
            return (T)value;
        }
        if (valClass == String.class) {
            return (T)String.valueOf(value);
        }
        boolean isEnum = valClass.isEnum();
        if (isEnum && BaseEnum.class.isAssignableFrom(valClass)) {
            T[] enumConstants = valClass.getEnumConstants();
            if (enumConstants == null) {
                return null;
            }
            for (T element : enumConstants) {
                BaseEnum baseEnum = (BaseEnum)element;
                if (!Objects.equals(String.valueOf(value), String.valueOf(baseEnum.getCode()))) continue;
                return element;
            }
            return null;
        }
        if (value.getClass() == Timestamp.class) {
            Timestamp timestamp = (Timestamp)value;
            if (valClass == java.util.Date.class) {
                return (T)timestamp;
            }
            if (valClass == Date.class) {
                return (T)new Date(timestamp.getTime());
            }
            if (valClass == LocalDateTime.class) {
                return (T)timestamp.toLocalDateTime();
            }
        }
        if (valClass == java.util.Date.class && value.getClass() == LocalDateTime.class) {
            LocalDateTime localDateTime = (LocalDateTime)value;
            return (T)java.util.Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
        }
        Object t = null;
        String strValue = String.valueOf(value);
        if (valClass == Byte.class || valClass == Byte.TYPE) {
            t = Byte.valueOf(strValue);
        }
        if (valClass == Short.class || valClass == Short.TYPE) {
            t = Short.valueOf(strValue);
        }
        if (valClass == Integer.class || valClass == Integer.TYPE) {
            t = Integer.valueOf(strValue);
        }
        if (valClass == Long.class || valClass == Long.TYPE) {
            t = Long.valueOf(strValue);
        }
        if (valClass == Float.class || valClass == Float.TYPE) {
            t = Float.valueOf(strValue);
        }
        if (valClass == Double.class || valClass == Double.TYPE) {
            t = Double.valueOf(strValue);
        }
        if (valClass == Character.class || valClass == Character.TYPE) {
            t = Character.valueOf(strValue.charAt(0));
        }
        if (valClass == BigDecimal.class) {
            Object object = t = value.getClass() == BigDecimal.class ? value : new BigDecimal(strValue);
        }
        if (valClass == BigInteger.class) {
            Object object = t = value.getClass() == BigInteger.class ? value : new BigInteger(strValue);
        }
        if (valClass == AtomicInteger.class) {
            Object object = t = value.getClass() == AtomicInteger.class ? value : new AtomicInteger(Integer.valueOf(strValue));
        }
        if (valClass == AtomicLong.class) {
            Object object = t = value.getClass() == AtomicLong.class ? value : new AtomicLong(Long.valueOf(strValue));
        }
        if (valClass == Boolean.class || valClass == Boolean.TYPE) {
            String temp = strValue;
            if ("0".equals(strValue)) {
                temp = "false";
            } else if ("1".equals(strValue)) {
                temp = "true";
            }
            t = Boolean.valueOf(temp);
        }
        if (t != null) {
            return (T)t;
        }
        return (T)value;
    }

    static class MethodBean {
        private final Method method;
        private final Class<?> paramType;

        public MethodBean(Method method, Class<?> paramType) {
            this.method = method;
            this.paramType = paramType;
        }

        public Method getMethod() {
            return this.method;
        }

        public Class<?> getParamType() {
            return this.paramType;
        }
    }
}

