/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.util;

import com.gitee.fastmybatis.core.PageInfo;
import com.gitee.fastmybatis.core.PageResult;
import com.gitee.fastmybatis.core.exception.QueryException;
import com.gitee.fastmybatis.core.ext.spi.BeanExecutor;
import com.gitee.fastmybatis.core.ext.spi.SpiContext;
import com.gitee.fastmybatis.core.mapper.SchMapper;
import com.gitee.fastmybatis.core.query.Query;
import com.gitee.fastmybatis.core.query.param.IParam;
import com.gitee.fastmybatis.core.support.PageEasyui;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;

public class MapperUtil {
    private static final Log logger = LogFactory.getLog(MapperUtil.class);

    private MapperUtil() {
    }

    public static <E, T> PageEasyui<T> queryForEasyuiDatagrid(SchMapper<E, ?> mapper, Query query, Class<T> clazz) {
        PageEasyui<Object> pageInfo = MapperUtil.queryForEasyuiDatagrid(mapper, query);
        List<E> list = pageInfo.getRows();
        if (list != null) {
            ArrayList<Object> newList = new ArrayList<Object>(list.size());
            BeanExecutor beanExecutor = SpiContext.getBeanExecutor();
            try {
                for (E element : list) {
                    if (clazz == element.getClass()) {
                        newList.add(element);
                        continue;
                    }
                    T t = clazz.newInstance();
                    beanExecutor.copyProperties(element, t);
                    newList.add(t);
                }
                pageInfo.setList(newList);
            }
            catch (Exception e) {
                throw new QueryException(e);
            }
        } else {
            pageInfo.setList(Collections.emptyList());
        }
        return pageInfo;
    }

    @Deprecated
    public static <E, T> PageInfo<T> queryAndConvert(SchMapper<E, ?> mapper, Query query, Class<T> clazz) {
        return MapperUtil.queryAndConvert(mapper, query, () -> {
            try {
                return clazz.newInstance();
            }
            catch (Exception e) {
                logger.error("\u751f\u6210\u5bf9\u8c61\u9519\u8bef\uff0cclass=" + clazz, (Throwable)e);
                return null;
            }
        });
    }

    public static <E, T> PageInfo<T> queryAndConvert(SchMapper<E, ?> mapper, Query query, Supplier<T> supplier) {
        PageInfo<Object> pageInfo = MapperUtil.query(mapper, query);
        List<E> list = pageInfo.getList();
        if (list != null) {
            ArrayList<T> newList = new ArrayList<T>(list.size());
            BeanExecutor beanExecutor = SpiContext.getBeanExecutor();
            try {
                for (E element : list) {
                    T t = supplier.get();
                    beanExecutor.copyProperties(element, t);
                    newList.add(t);
                }
                pageInfo.setList(newList);
            }
            catch (Exception e) {
                throw new QueryException(e);
            }
        } else {
            pageInfo.setList(Collections.emptyList());
        }
        return pageInfo;
    }

    public static <E> PageEasyui<E> queryForEasyuiDatagrid(SchMapper<E, ?> mapper, Query query) {
        return MapperUtil.query(mapper, query, PageEasyui.class);
    }

    public static int calcPageCount(long total, int pageSize) {
        return (int)(pageSize == 0 ? 1L : (total + (long)pageSize - 1L) / (long)pageSize);
    }

    public static <Entity> PageInfo<Entity> query(SchMapper<Entity, ?> mapper, Object bean) {
        return MapperUtil.query(mapper, Query.build(bean), PageInfo.class);
    }

    public static <Entity> PageInfo<Entity> query(SchMapper<Entity, ?> mapper, IParam searchParam) {
        return MapperUtil.query(mapper, Query.build(searchParam), PageInfo.class);
    }

    public static <Entity> PageInfo<Entity> query(SchMapper<Entity, ?> mapper, Query query) {
        return MapperUtil.query(mapper, query, PageInfo.class);
    }

    public static <Entity, T extends PageResult<Entity>> T query(SchMapper<Entity, ?> mapper, Query query, Class<T> pageResultClass) {
        PageResult result = null;
        try {
            result = (PageResult)pageResultClass.newInstance();
        }
        catch (Exception e) {
            throw new QueryException(e);
        }
        try {
            int pageCount = 0;
            long total = 0L;
            int pageSize = query.getLimit();
            List<Object> list = Collections.emptyList();
            if (query.getIsQueryAll()) {
                list = mapper.list(query);
                total = list.size();
                if (total > 0L) {
                    pageCount = 1;
                }
            } else {
                total = query.getIsSetTotal() ? (long)query.getTotal() : mapper.getCount(query);
                if (total > 0L) {
                    list = mapper.list(query);
                    int start = query.getStart();
                    int pageIndex = start / pageSize + 1;
                    result.setStart(start);
                    result.setPageIndex(pageIndex);
                    pageCount = MapperUtil.calcPageCount(total, pageSize);
                }
            }
            result.setPageSize(pageSize);
            result.setList(list);
            result.setTotal(total);
            result.setPageCount(pageCount);
        }
        catch (Exception e) {
            throw new QueryException(e);
        }
        return (T)result;
    }

    public static <T> PageInfo<T> query(List<String> columns, SchMapper<?, ?> mapper, Query query, Class<T> clazz) {
        if (columns == null || columns.isEmpty()) {
            throw new IllegalArgumentException("parameter 'columns' can not empty");
        }
        Objects.requireNonNull(query, "parameter 'query' can not null");
        Objects.requireNonNull(clazz, "parameter 'clazz' can not null");
        PageInfo result = new PageInfo();
        try {
            int pageCount = 0;
            long total = 0L;
            List list = Collections.emptyList();
            if (query.getIsQueryAll()) {
                list = mapper.listBySpecifiedColumns(columns, query, clazz);
                total = list.size();
                if (total > 0L) {
                    pageCount = 1;
                }
            } else {
                total = query.getIsSetTotal() ? (long)query.getTotal() : mapper.getCount(query);
                if (total > 0L) {
                    list = mapper.listBySpecifiedColumns(columns, query, clazz);
                    int start = query.getStart();
                    int pageSize = query.getLimit();
                    int pageIndex = start / pageSize + 1;
                    result.setStart(start);
                    result.setPageIndex(pageIndex);
                    result.setPageSize(pageSize);
                    pageCount = MapperUtil.calcPageCount(total, pageSize);
                }
            }
            result.setList(list);
            result.setTotal(total);
            result.setPageCount(pageCount);
        }
        catch (Exception e) {
            logger.error("query error", (Throwable)e);
            throw new QueryException(e);
        }
        return result;
    }

    public static <T> PageInfo<T> query(Query query, Function<Query, Long> totalGetter, Function<Query, List<T>> listGetter) {
        return MapperUtil.query(query, totalGetter, listGetter, PageInfo::new);
    }

    public static <T, R extends PageResult<T>> R query(Query query, Function<Query, Long> totalGetter, Function<Query, List<T>> listGetter, Supplier<R> pageInfoGetter) {
        PageResult result = (PageResult)pageInfoGetter.get();
        try {
            int pageCount = 0;
            long total = 0L;
            List list = Collections.emptyList();
            if (query.getIsQueryAll()) {
                list = listGetter.apply(query);
                total = list.size();
                if (total > 0L) {
                    pageCount = 1;
                }
            } else {
                total = query.getIsSetTotal() ? (long)query.getTotal() : totalGetter.apply(query);
                if (total > 0L) {
                    list = listGetter.apply(query);
                    int start = query.getStart();
                    int pageSize = query.getLimit();
                    int pageIndex = start / pageSize + 1;
                    result.setStart(start);
                    result.setPageIndex(pageIndex);
                    result.setPageSize(pageSize);
                    pageCount = MapperUtil.calcPageCount(total, pageSize);
                }
            }
            result.setList(list);
            result.setTotal(total);
            result.setPageCount(pageCount);
        }
        catch (Exception e) {
            throw new QueryException(e);
        }
        return (R)result;
    }
}

