/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.util;

import com.gitee.fastmybatis.core.ext.code.util.ReflectUtil;
import java.lang.reflect.Field;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;

public class ListUtil {
    public static <T> List<List<T>> partition(List<T> list, int size) {
        Objects.requireNonNull(list);
        if (size < 1) {
            throw new IllegalArgumentException("size must > 0");
        }
        return list instanceof RandomAccess ? new RandomAccessPartition<T>(list, size) : new Partition<T>(list, size);
    }

    public static <T> List<String> getNotNullFieldNames(Collection<T> list) {
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("argument 'list' can not empty");
        }
        T obj = list.iterator().next();
        Class<?> entityClass = obj.getClass();
        List<Field> fields = ReflectUtil.getDeclaredFields(entityClass);
        ArrayList<String> notNullFieldNames = new ArrayList<String>(fields.size());
        for (Field field : fields) {
            field.setAccessible(true);
            Object value = ReflectUtil.getField(field, obj);
            if (value == null) continue;
            notNullFieldNames.add(field.getName());
        }
        return notNullFieldNames;
    }

    private static int checkElementIndex(int index, int size) {
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException("index error, index:" + index + ", size:" + size);
        }
        return index;
    }

    private static class RandomAccessPartition<T>
    extends Partition<T>
    implements RandomAccess {
        RandomAccessPartition(List<T> list, int size) {
            super(list, size);
        }
    }

    private static class Partition<T>
    extends AbstractList<List<T>> {
        final List<T> list;
        final int size;

        Partition(List<T> list, int size) {
            this.list = list;
            this.size = size;
        }

        @Override
        public List<T> get(int index) {
            ListUtil.checkElementIndex(index, this.size());
            int start = index * this.size;
            int end = Math.min(start + this.size, this.list.size());
            return this.list.subList(start, end);
        }

        @Override
        public int size() {
            return (this.list.size() + this.size - 1) / this.size;
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }
    }
}

