/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.ibatis.io.Resources;

public class IOUtil {
    private static final int EOF = -1;
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final String UTF_8 = "UTF-8";

    public static InputStream toInputStream(String input, Charset encoding) {
        return new ByteArrayInputStream(input.getBytes(encoding));
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static int copy(Reader input, Writer output) throws IOException {
        long count = IOUtil.copyLarge(input, output, new char[4096]);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static long copyLarge(Reader input, Writer output, char[] buffer) throws IOException {
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static String toString(InputStream input, Charset encoding) throws IOException {
        StringBuilderWriter sw = new StringBuilderWriter();
        IOUtil.copy(input, sw, encoding);
        return sw.toString();
    }

    public static void copy(InputStream input, Writer output, Charset encoding) throws IOException {
        InputStreamReader in = new InputStreamReader(input, encoding);
        IOUtil.copy(in, output);
    }

    public static List<String> readLines(InputStream input, Charset encoding) throws IOException {
        InputStreamReader reader = new InputStreamReader(input, encoding);
        return IOUtil.readLines(reader);
    }

    public static List<String> readLines(Reader input) throws IOException {
        BufferedReader reader = IOUtil.toBufferedReader(input);
        ArrayList<String> list = new ArrayList<String>();
        String line = reader.readLine();
        while (line != null) {
            list.add(line);
            line = reader.readLine();
        }
        return list;
    }

    public static BufferedReader toBufferedReader(Reader reader) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public static void closeQuietly(Closeable ... closeables) {
        if (closeables == null) {
            return;
        }
        for (Closeable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static List<ResourceFile> listFiles(File file, String extension) throws IOException {
        File[] subFiles;
        ArrayList<ResourceFile> files = new ArrayList<ResourceFile>();
        String filename = file.getName();
        if (file.isFile() && filename.toLowerCase().endsWith(extension)) {
            String content = IOUtil.toString(file, StandardCharsets.UTF_8);
            files.add(new ResourceFile(filename, content));
            return files;
        }
        if (file.isDirectory() && (subFiles = file.listFiles()) != null && subFiles.length > 0) {
            for (File subFile : subFiles) {
                List<ResourceFile> fileList = IOUtil.listFiles(subFile, extension);
                files.addAll(fileList);
            }
        }
        return files;
    }

    public static String toString(File file, Charset encoding) throws IOException {
        try (FileInputStream in = IOUtil.openInputStream(file);){
            String string = IOUtil.toString(in, encoding);
            return string;
        }
    }

    public static FileInputStream openInputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canRead()) {
                throw new IOException("File '" + file + "' cannot be read");
            }
        } else {
            throw new FileNotFoundException("File '" + file + "' does not exist");
        }
        return new FileInputStream(file);
    }

    public static List<ResourceFile> listJarFiles(String classpath, String extension) throws IOException {
        URL resourceURL = null;
        try {
            resourceURL = Resources.getResourceURL((String)classpath);
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
        URLConnection urlConnection = resourceURL.openConnection();
        ArrayList<ResourceFile> list = new ArrayList<ResourceFile>();
        if (urlConnection instanceof JarURLConnection) {
            JarURLConnection jarURLConnection = (JarURLConnection)urlConnection;
            JarFile jarFile = jarURLConnection.getJarFile();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                String name = jarEntry.getName();
                if (jarEntry.isDirectory() || !name.startsWith(classpath) || !name.endsWith(extension)) continue;
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                String content = IOUtil.toString(inputStream, StandardCharsets.UTF_8);
                list.add(new ResourceFile(name, content));
            }
        } else if (Objects.equals(urlConnection.getClass().getCanonicalName(), "sun.net.www.protocol.file.FileURLConnection")) {
            String filePath = URLDecoder.decode(resourceURL.getPath(), UTF_8);
            File folder = new File(filePath);
            List<ResourceFile> resourceFiles = IOUtil.listFiles(folder, extension);
            list.addAll(resourceFiles);
        }
        return list;
    }

    public static class StringBuilderWriter
    extends Writer
    implements Serializable {
        private static final long serialVersionUID = -146927496096066153L;
        private final StringBuilder builder;

        public StringBuilderWriter() {
            this.builder = new StringBuilder();
        }

        public StringBuilderWriter(int capacity) {
            this.builder = new StringBuilder(capacity);
        }

        public StringBuilderWriter(StringBuilder builder) {
            this.builder = builder != null ? builder : new StringBuilder();
        }

        @Override
        public Writer append(char value) {
            this.builder.append(value);
            return this;
        }

        @Override
        public Writer append(CharSequence value) {
            this.builder.append(value);
            return this;
        }

        @Override
        public Writer append(CharSequence value, int start, int end) {
            this.builder.append(value, start, end);
            return this;
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(String value) {
            if (value != null) {
                this.builder.append(value);
            }
        }

        @Override
        public void write(char[] value, int offset, int length) {
            if (value != null) {
                this.builder.append(value, offset, length);
            }
        }

        public StringBuilder getBuilder() {
            return this.builder;
        }

        public String toString() {
            return this.builder.toString();
        }
    }

    public static class ResourceFile {
        private String filename;
        private String content;

        public ResourceFile(String filename, String content) {
            this.filename = filename;
            this.content = content;
        }

        public InputStream getInputStream() {
            return IOUtil.toInputStream(this.content, StandardCharsets.UTF_8);
        }

        public String getFilename() {
            return this.filename;
        }

        public void setFilename(String filename) {
            this.filename = filename;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public String toString() {
            return "ResourceFile{filename='" + this.filename + '\'' + '}';
        }
    }
}

