/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.util;

import com.gitee.fastmybatis.core.ext.exception.DatabaseConnectException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;

public class DbUtil {
    private static final Log LOG = LogFactory.getLog(DbUtil.class);

    public static String getDialect(DataSource dataSource) {
        if (dataSource == null) {
            throw new NullPointerException("dataSource \u4e0d\u80fd\u4e3anull");
        }
        Connection conn = null;
        try {
            conn = dataSource.getConnection();
            DatabaseMetaData metaData = conn.getMetaData();
            String productName = metaData.getDatabaseProductName();
            LOG.debug("\u6570\u636e\u5e93\u540d\u79f0\uff1a" + productName);
            String string = productName;
            return string;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new DatabaseConnectException(e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

