/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class ClassUtil {
    private static final String PROXY_PREFIX = "com.sun.proxy";
    private static final Map<String, Class<?>> CACHE = new ConcurrentHashMap(16);

    private ClassUtil() {
    }

    public static Class<?> getSuperClassGenricType(Class<?> clazz, int index) throws IndexOutOfBoundsException {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            return Object.class;
        }
        return (Class)params[index];
    }

    public static Class<?> getSuperInterfaceGenericType(Class<?> clazz, int index) {
        String key = clazz.getName() + index;
        return CACHE.computeIfAbsent(key, k -> ClassUtil.doGetSuperInterfaceGenericType(clazz, index));
    }

    private static Class<?> doGetSuperInterfaceGenericType(Class<?> clazz, int index) {
        String name = clazz.getName();
        if (name.startsWith(PROXY_PREFIX)) {
            Type[] interfacesTypes = clazz.getGenericInterfaces();
            if (interfacesTypes.length == 0) {
                return Object.class;
            }
            clazz = (Class)interfacesTypes[0];
            return ClassUtil.doGetSuperInterfaceGenericType(clazz, index);
        }
        Type[] interfacesTypes = clazz.getGenericInterfaces();
        if (interfacesTypes.length == 0) {
            return Object.class;
        }
        Type firstInterface = interfacesTypes[0];
        Type[] params = ((ParameterizedType)firstInterface).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            return Object.class;
        }
        return (Class)params[index];
    }

    public static boolean isArrayOrCollection(Object value) {
        boolean ret = false;
        if (value.getClass().isArray()) {
            ret = true;
        } else if (value instanceof Collection) {
            ret = true;
        }
        return ret;
    }

    public static boolean isPrimitive(String type0) {
        if (Objects.isNull(type0)) {
            return true;
        }
        String type = type0.contains("java.lang") ? type0.substring(type0.lastIndexOf(".") + 1, type0.length()) : type0;
        switch (type = type.toLowerCase()) {
            case "string": 
            case "integer": 
            case "int": 
            case "object": 
            case "void": 
            case "long": 
            case "double": 
            case "float": 
            case "short": 
            case "bigdecimal": 
            case "char": 
            case "character": 
            case "number": 
            case "boolean": 
            case "byte": 
            case "uuid": 
            case "biginteger": 
            case "java.sql.timestamp": 
            case "java.util.date": 
            case "java.time.localdatetime": 
            case "java.time.localtime": 
            case "localtime": 
            case "date": 
            case "localdatetime": 
            case "localdate": 
            case "zoneddatetime": 
            case "java.time.localdate": 
            case "java.time.zoneddatetime": 
            case "java.math.bigdecimal": 
            case "java.math.biginteger": 
            case "java.util.uuid": 
            case "java.io.serializable": {
                return true;
            }
        }
        return false;
    }

    public static <A extends Annotation> A findAnnotation(Class<?> clazz, Class<A> annotationType) {
        Annotation[] declaredAnnotations;
        for (Annotation declaredAnnotation : declaredAnnotations = clazz.getDeclaredAnnotations()) {
            if (declaredAnnotation.annotationType() != annotationType) continue;
            return (A)declaredAnnotation;
        }
        return null;
    }

    public static Field findField(Class<?> clazz, String name) {
        if (name == null) {
            return null;
        }
        for (Class<?> searchType = clazz; Object.class != searchType && searchType != null; searchType = searchType.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = searchType.getDeclaredFields()) {
                if (!name.equals(field.getName())) continue;
                return field;
            }
        }
        return null;
    }

    public static void makeAccessible(Field field) {
        if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
            field.setAccessible(true);
        }
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("create instance error", e);
        }
    }
}

