/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.support.plugin;

import com.gitee.fastmybatis.core.support.plugin.DefaultSqlFormatterHandler;
import com.gitee.fastmybatis.core.support.plugin.SqlFormatterHandler;
import com.gitee.fastmybatis.core.util.ClassUtil;
import java.sql.PreparedStatement;
import java.util.Properties;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;

@Intercepts(value={@Signature(type=ParameterHandler.class, method="setParameters", args={PreparedStatement.class})})
public class SqlFormatterPlugin
implements Interceptor {
    private static final Log LOG = LogFactory.getLog(SqlFormatterPlugin.class);
    private SqlFormatterHandler sqlFormatterHandler;

    public Object intercept(Invocation invocation) throws Throwable {
        try {
            Object object = invocation.proceed();
            return object;
        }
        finally {
            this.sqlFormatterHandler.doPrintSql(invocation);
        }
    }

    public void setProperties(Properties properties) {
        String handlerClass = properties.getProperty("handlerClass");
        if (handlerClass == null || "".equals(handlerClass)) {
            this.sqlFormatterHandler = new DefaultSqlFormatterHandler();
        } else {
            try {
                Object obj = ClassUtil.newInstance(Class.forName(handlerClass));
                if (!(obj instanceof SqlFormatterHandler)) {
                    throw new RuntimeException(handlerClass + " should implements SqlFormatterHandler");
                }
                this.sqlFormatterHandler = (SqlFormatterHandler)obj;
            }
            catch (Exception e) {
                LOG.warn("Init SqlFormatterHandler error:" + e.getMessage());
                this.sqlFormatterHandler = new DefaultSqlFormatterHandler();
            }
        }
        this.sqlFormatterHandler.setProperties(properties);
    }
}

