/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.support.plugin;

import com.gitee.fastmybatis.core.FastmybatisConfig;
import com.gitee.fastmybatis.core.support.plugin.SqlFormatter;
import com.gitee.fastmybatis.core.support.plugin.SqlFormatterHandler;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.PreparedStatement;
import java.util.Properties;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.plugin.Invocation;

public class DefaultSqlFormatterHandler
implements SqlFormatterHandler {
    protected static final Log LOG = LogFactory.getLog(DefaultSqlFormatterHandler.class);
    private final SqlFormatter sqlFormatter = new SqlFormatter();
    private Properties properties;
    private boolean appendDelimiter;
    private String delimiter;
    private boolean useDruid;
    private String format;
    private boolean enable;

    @Override
    public boolean canPrint(Invocation invocation) {
        return this.enable || FastmybatisConfig.PRINT_SQL || LOG.isDebugEnabled();
    }

    @Override
    public String getSql(Invocation invocation) throws Exception {
        InvocationHandler handler;
        PreparedStatement statement = (PreparedStatement)invocation.getArgs()[0];
        if (Proxy.isProxyClass(statement.getClass()) && (handler = Proxy.getInvocationHandler(statement)).getClass().getName().endsWith(".PreparedStatementLogger")) {
            Field field = handler.getClass().getDeclaredField("statement");
            field.setAccessible(true);
            statement = (PreparedStatement)field.get(handler);
            if (this.isUseDruid()) {
                Field stmt = statement.getClass().getDeclaredField("stmt");
                stmt.setAccessible(true);
                statement = (PreparedStatement)stmt.get(statement);
                Field clientStatement = statement.getClass().getDeclaredField("statement");
                clientStatement.setAccessible(true);
                statement = (PreparedStatement)clientStatement.get(statement);
            }
        }
        String statementSql = statement.toString();
        String sql = statementSql.replace("** BYTE ARRAY DATA **", "null").substring(statementSql.indexOf(":") + 1);
        String endMark = this.getDelimiter();
        if (this.isAppendDelimiter() && !sql.endsWith(endMark)) {
            sql = sql + endMark;
        }
        return sql;
    }

    @Override
    public String formatSql(String sql) {
        String fullSql = this.getSqlFormatter().format(sql);
        return String.format(this.getFormat(), fullSql);
    }

    @Override
    public void printSql(String sql) {
        LOG.warn(sql);
    }

    public SqlFormatter getSqlFormatter() {
        return this.sqlFormatter;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public boolean isAppendDelimiter() {
        return this.appendDelimiter;
    }

    public void setAppendDelimiter(boolean appendDelimiter) {
        this.appendDelimiter = appendDelimiter;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public boolean isUseDruid() {
        return this.useDruid;
    }

    public void setUseDruid(boolean useDruid) {
        this.useDruid = useDruid;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    public void setProperties(Properties properties) {
        this.properties = properties;
        this.appendDelimiter = Boolean.parseBoolean(properties.getProperty("appendDelimiter", "true"));
        this.enable = Boolean.parseBoolean(properties.getProperty("enable", "false"));
        this.useDruid = Boolean.parseBoolean(properties.getProperty("useDruid", "false"));
        this.delimiter = properties.getProperty("delimiter", ";");
        this.format = properties.getProperty("format", "\n====== SQL ======\n%s").replace("\\n", "\n");
    }
}

